package cn.com.duiba.youqian.center.api.util;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.youqian.center.api.exception.StandardCode;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.XMLWorker;
import com.itextpdf.tool.xml.XMLWorkerFontProvider;
import com.itextpdf.tool.xml.XMLWorkerHelper;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersImpl;
import com.itextpdf.tool.xml.html.Tags;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

import java.io.*;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;

/**
 * @类描述 实现java html 转pdf
 */
@Slf4j
public class PDFUtil {

	public static void main(String[] args) throws BizException, IOException {
		FileUtils.writeByteArrayToFile(new File("C:\\Users\\Duiba\\Desktop\\s1.pdf"),replacePdf(pdfStr));
	}

	static String pdfStr = "<p style=\"text-align:center;\">\n" +
			"    <strong><span style=\";font-family:宋体;;font-weight:bold;font-size:24px\"><span style=\"font-family:宋体\">购销合同</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"text-align:right;\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">合同编号：【</span> </span><span style=\";font-family:宋体;font-size:14px\">${orderNo}</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">】</span></span>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">甲方（购货方）：${buyerName}</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">统一社会信用代码（身份证号码）：${buyerIdCard}</span></span>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">联系人：${buyerContact}</span></span>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">联系电话：${buyerMobile}</span> </span><span style=\";font-family:宋体;font-size:14px\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\">&nbsp;</span></strong>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">乙方（供货方）：${sellName}</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">统一社会信用代码（身份证号码）：${sellIdCard}</span></span>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">联系人：${sellContact}</span></span>\n" +
			"</p>\n" +
			"<p style=\"\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">联系电话：${sellMobile}</span></span>\n" +
			"</p>\n" +
			"<p style=\";text-align:left;\">\n" +
			"    <span style=\";font-family:宋体;;color:rgb(17,31,44);font-size:14px;background:rgb(255,255,255)\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"text-indent:28px;text-align:left;\">\n" +
			"    <span style=\";font-family:宋体;;color:rgb(17,31,44);font-size:14px;background:rgb(255,255,255)\"><span style=\"font-family:宋体\">根据《中国人民共和国合同法》及相关法律法规，本着诚实信用、平等互利的原则，就购销货物相关事宜，甲乙双方达成本协议，并共同声明如下：</span></span>\n" +
			"</p>\n" +
			"<p style=\"text-indent:28px;text-align:left;\">\n" +
			"    <strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;;color:rgb(17,31,44);font-weight:bold;text-underline:single;font-size:14px;background:rgb(255,255,255)\"><span style=\"font-family:宋体\">甲乙双方有资格签订本协议，并完全理解本协议的全部内容，承诺共同遵守、执行协议约定。</span></span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"text-indent:28px;text-align:left;\">\n" +
			"    <strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;;color:rgb(17,31,44);font-weight:bold;text-underline:single;font-size:14px;background:rgb(255,255,255)\"><span style=\"font-family:宋体\">甲乙双方了解本协议是通过数据电文形式订立的电子合同，具备法律效力。在发生争议时，甲乙双方同意按照本协议的约定协商处理，但甲乙双方另有约定的除外。</span></span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"text-indent:28px;text-align:left;\">\n" +
			"    <strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;;color:rgb(17,31,44);font-weight:bold;text-underline:single;font-size:14px;background:rgb(255,255,255)\">&nbsp;</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-align:left;\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第一条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">购货清单</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";text-align:left;\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">货物清单：</span></span></strong>\n" +
			"</p>\n" +
			"<p>\n" +
			"    &nbsp;<br/>\n" +
			"</p>\n" +
			"<p>\n" +
			"    ${goods}\n" +
			"</p>\n" +
			"<p>\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">结算方式：</span></span></strong>\n" +
			"</p>\n" +
			"<p>\n" +
			"    &nbsp;<br/>\n" +
			"</p>\n" +
			"<p>\n" +
			"    ${paymentInfo}\n" +
			"</p>\n" +
			"<p>\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">交货事项</span></span></strong>\n" +
			"</p>\n" +
			"<p>\n" +
			"    &nbsp;<br/>\n" +
			"</p>\n" +
			"<p>\n" +
			"    &nbsp; &nbsp;\n" +
			"    ${receiveName}\n" +
			"</p>\n" +
			"<table style=\"background-color:#000000;\" border=\"0\">\n" +
			"    <tbody>\n" +
			"        <tr style=\"background-color:#ffffff;\" class=\"firstRow\">\n" +
			"            <td width=\"553\">\n" +
			"                <p>\n" +
			"                    <span style=\"font-family:宋体;\">物流运输:${transportWay}</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#ffffff;\">\n" +
			"            <td width=\"553\">\n" +
			"                <p>\n" +
			"                    <span style=\";font-family:宋体\">交货地点:${address}</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#ffffff;\">\n" +
			"            <td width=\"553\">\n" +
			"                <p>\n" +
			"                    <span style=\"font-family:宋体\">交货时间:${deliveryTime}</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"    </tbody>\n" +
			"</table>\n" +
			"<p>\n" +
			"    <strong><span style=\"font-family:宋体\"><span style=\"font-family:宋体\">合同金额总价构成</span></span></strong>\n" +
			"</p>\n" +
			"<p>\n" +
			"    &nbsp;<br/>\n" +
			"</p>\n" +
			"<table style=\"background-color:#000000;\" border=\"0\">\n" +
			"    <tbody>\n" +
			"        <tr class=\"firstRow\" style=\"background-color:#ffffff;\">\n" +
			"            <td width=\"198\">\n" +
			"                <p style=\"\">\n" +
			"                    <span style=\"font-family:宋体;\">货物总价:${totalGoodsPrice}</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"            <td width=\"236\">\n" +
			"                <p style=\"\">\n" +
			"                    <span style=\"font-family:宋体\">运费总计:${totalFreightPrice}</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"        <tr style=\"background-color:#ffffff;\">\n" +
			"            <td colspan=\"2\" width=\"434\">\n" +
			"                <p style=\"\">\n" +
			"                    <span style=\"font-family:宋体\">总计:${totalPrice}</span>\n" +
			"                </p>\n" +
			"            </td>\n" +
			"        </tr>\n" +
			"    </tbody>\n" +
			"</table>\n" +
			"<p>\n" +
			"    <strong><span style=\"font-family:宋体\"><span style=\"font-family:宋体\">备注：（其他双方自行约定事项）</span></span></strong>\n" +
			"</p>\n" +
			"<p>\n" +
			"    &nbsp;<br/>\n" +
			"</p>\n" +
			"<table style=\"background-color:#000000;\" border=\"0\">\n" +
			"    <tbody>\n" +
			"        <tr style=\"height:63px;background-color:#ffffff;\" class=\"firstRow\">\n" +
			"            <td width=\"553\">${otherDesc}</td>\n" +
			"        </tr>\n" +
			"    </tbody>\n" +
			"</table>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\">&nbsp;</span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第二条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">货物质量、包装、验收及交付</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">1、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">本协议项下的货物质量应符合《中华人民共和国产品质量法》及相关法律法规的要求、若有国家标准、行业标准的，则应满足相关标准。货物本身有《产品说明书》、《产品合格证》、《保修单》等有关单据和资料的，实际交付的货物应与单据资料一致。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">货物包装应严密安全，能够起到防护货物的作用。若货物存在严重破损、货物外漏、污渍影响货物质量的情形，甲方有权拒收。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\">3、</span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">除双方另有约定外，自货物送达至交货地点即视为交付。甲</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">方对</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">货物</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">质量有异议的，应当在收到</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">货物</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">后</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;color:rgb(255,0,0);font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">三</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">日内</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">通知乙</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">方；逾期不提出异议的，</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">则</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">视为</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">乙</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">方</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">货物</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">质量符合要求。但</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">甲</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">方</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">已</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">使用</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">乙</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">方</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">货物</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">的，不受上述期限限制，视为</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">乙</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">方</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">货物</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">符合要求。</span></span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第三条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">甲方的权利与义务</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">1、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">甲方保证使用自有、合法资金向甲方采购该批货物，并且按时付款至乙方指定的收款账户。</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">非经</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">乙方</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">书面同意或确认，</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">甲方</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">对</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">乙方</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">任何人员的个人借款，</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">或向非乙方指定账户支付的任何款项，均</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">不构成</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">甲方</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">对</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">乙</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">方的预付款或已付款款项。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">甲方应及时清点货物数量、验收货物质量，不得无故拒收。因甲方拒收给乙方造成损失的，甲方应负责赔偿，包括但不限于：运输费用损失、仓储保管费用、货物预期收益、乙方为主张权利所支出的全部合理费用。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">3、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">甲方变更收货人地址或联系人信息的，应及时通知乙方，为乙方预留充足的准备时间。因前述情形导致乙方交货延迟的，乙方不承担违约责任。若甲方通知乙方时，货物已发出，乙方应配合乙方协调交货地址变更相关事宜，因此支出的额外费用由甲方承担。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">4、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">除非乙方事先同意，甲方不得将本协议项下的货物价格、乙方经营信息、乙方合作伙伴及基于一般商业判断应认定为乙方的专属秘密信息，透露给乙方的竞争对手。若甲方违反前述约定给乙方造成损失的，甲方应予以赔偿。</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第四条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">乙方的权利与义务</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">1、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">乙方保证有权利向甲方销售该批货物，货物来源合法、正当，未侵犯任何第三方的合法权益。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">乙方应按时按量交货，除非不可抗力、甲方事先同意或本协议另有约定外，乙方不得无故延迟交货、减少发货数量。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">3、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">若甲方未按时付款，乙方有权延迟该批货物或下批货物的发货时间，该情形不视为乙方违约。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">4、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">若甲方对货物有任何疑问，乙方应及时给予回复。若甲乙双方另行约定售后服务的，应按照相关约定执行。</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第五条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">违约责任</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">1、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">若甲方未按时向乙方付款，经乙方催告后，甲方仍未付款的，应按照</span></span><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">拖欠金额</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\">×<span style=\"font-family:Apple Color Emoji\">️</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">万分之五</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\">×<span style=\"font-family:Apple Color Emoji\">️</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">拖欠天数</span></span></span></strong><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">的标准向乙方支付违约金，并承担乙方为主张权利所支出的全部合理费用（包括但不限于律师费、诉讼费、差旅费、公告费、执行费等），拖欠天数自协议约定的付款之日起算。超过</span>3</span><span style=\";font-family:Cambria;font-size:14px\">0</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">个自然日，甲方仍未付款的，即视为甲方根本违约，乙方有权解除本协议及双方签署的其他协议，终止发货。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2<span style=\"font-family:宋体\">、</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">若乙方未按时向甲方交货，经甲方催告后，乙方仍不能按时交货的，甲方有权解除本协议，并要求乙方退还已支付的定金、预付款（若有）。乙方拒不退款的，甲方有权要求乙方按照</span></span><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">未退款金额</span></span></span></strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\">×</span></span><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:Apple Color Emoji\">️</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">万分之五</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\">×<span style=\"font-family:Apple Color Emoji\">️</span></span></span></strong><strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">逾期天数</span></span></span></strong><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">的标准支付违约金，逾期天数自甲方催告之日起算。</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;line-height:150%\">\n" +
			"    <strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\">&nbsp;</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第六条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">协议的生效、终止、解除</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\">1、</span></strong><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">本协议为单次购销合同，自双方签订之日生效，至本协议履行完毕之日终止。若甲乙双方在签署本协议后，就其他货物购销再次签署《购销合同》的，应分别有效、独立适用。</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">除以下情形外，任何一方不得单方解除本协议：</span></span>\n" +
			"</p>\n" +
			"<p style=\"text-indent:28px;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">1）</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">因不可抗力致使协议无法履行的；</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2）</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">一方严重违反本协议的约定，而导致协议目的无法实现的；</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">3）</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">本协议约定的其他情形。</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">&nbsp;</span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第七条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">不可抗力</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">1、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">因火灾、战争、罢工、自然灾害等不可抗力因素而致本</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">协议</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">不能履行的，双方终止</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">协议</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">的履行，各自的损失各自承担。不可抗力因素消失后，双方需要继续履行</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">协议</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">的，</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">应</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">另行协商。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">因不可抗力终止</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">协议</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">履行的一方，应当于事件发生后</span>7</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">个工作</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">日内向对方提供</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">相关</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">部门出具的发生不可抗力事件的证明文件并及时通知对方。未履行通知义务而致损失扩大的，过错方应当承担赔偿责任。</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;line-height:150%\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\">&nbsp;</span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第八条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">争议解决</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:0;text-indent:0;line-height:150%\">\n" +
			"    <strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\"><span style=\"font-family:宋体\">本协议履行期间产生的争议，应友好协商解决，协商解决不成的，双方同意由原告住所地的人民法院诉讼解决。</span></span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;line-height:150%\">\n" +
			"    <strong><span style=\"text-decoration:underline;\"><span style=\";font-family:宋体;font-weight:bold;text-underline:single;font-size:14px\">&nbsp;</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;line-height:150%\">\n" +
			"    <span style=\"font-family:宋体;font-weight:bold;font-size:14px\">第九条&nbsp;</span><strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">其他</span></span></strong>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">1、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">本</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">协议</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">未约定的事项，由双方另行签订补充协议，补充协议与本</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">协议</span></span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">具有同等法律效力。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">2、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">任何一方变更本协议项下的联系信息的，应及时通知对方。未提前通知的，由信息变更方自行承担相应责任。</span></span>\n" +
			"</p>\n" +
			"<p style=\";line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\">3、</span><span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">本协议自甲乙双方签署后生效。</span></span>\n" +
			"</p>\n" +
			"<p style=\"margin-left:28px;text-indent:0;text-align:center;line-height:150%\">\n" +
			"    <span style=\";font-family:宋体;font-size:14px\"><span style=\"font-family:宋体\">（以下无正文）</span></span>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><br/></span></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"><span style=\"font-family:宋体\">甲方（盖章</span>/签名）：&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style=\"font-family:宋体\">乙方（盖章</span>/签名）：</span></strong><strong><sub><span style=\";font-family:宋体;font-weight:bold;font-size:14px;vertical-align:sub\"></span></sub></strong>\n" +
			"</p>\n" +
			"<p style=\"line-height:150%\">\n" +
			"    <strong><span style=\";font-family:宋体;font-weight:bold;font-size:14px\"></span></strong><br/>\n" +
			"</p>\n" +
			"<p>\n" +
			"    <br/>\n" +
			"</p>";

	public static byte[] replacePdf(String xhtml) throws BizException {
		ByteArrayOutputStream outputStream = new ByteArrayOutputStream();

		// step 1
		Document document = new Document(PageSize.A4);

		// step 2
		PdfWriter writer;
		try {
			writer = PdfWriter.getInstance(document, outputStream);
		} catch (DocumentException e) {
			log.error("HTML转换PDF异常", e);
			throw new BizException("HTML转换PDF异常").withCode(StandardCode.UNKNOWN_ERROR.getStrCode());
		}

		// step 3
		document.open();

		// step 4
		XMLWorkerFontProvider fontProvider = new MyFontProvider("/fonts/SimSun.ttf", "Identity-H");

		// 使用我们的字体提供器，并将其设置为unicode字体样式
		CssAppliers cssAppliers = new CssAppliersImpl(fontProvider);

		// CSS
		CSSResolver cssResolver = XMLWorkerHelper.getInstance().getDefaultCssResolver(true);

		// HTML
		HtmlPipelineContext htmlContext = new HtmlPipelineContext(cssAppliers);
		htmlContext.setTagFactory(Tags.getHtmlTagProcessorFactory());

		// Pipelines
		PdfWriterPipeline pdf = new PdfWriterPipeline(document, writer);
		HtmlPipeline html = new HtmlPipeline(htmlContext, pdf);
		CssResolverPipeline css = new CssResolverPipeline(cssResolver, html);

		// XML Worker
		XMLWorker worker = new XMLWorker(css, true);
		XMLParser p = new XMLParser(worker);
		try {
			p.parse(new ByteArrayInputStream(xhtml.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
		} catch (IOException e) {
			log.error("HTML转换PDF异常", e);
			throw new BizException("HTML转换PDF异常").withCode(StandardCode.UNKNOWN_ERROR.getStrCode());
		} finally {
			// step 5
			try {
				document.close();
				outputStream.close();
			} catch (Exception e) {
				//ignore
			}
		}

		return outputStream.toByteArray();
	}

	/**
	 * 获取PDF 总页数
	 */
	public static int getPages(byte[] pdfByte) {
		//2 加载PDF
		PDDocument pdDocument = null;
		try {
			pdDocument = PDDocument.load(pdfByte);
			// 3 获取页码
			return pdDocument.getNumberOfPages();
		} catch (IOException e) {
			log.error("IO exception:[{}]",e);
		}finally {
			try {
				if (pdDocument != null) {
					pdDocument.close();
				}
			} catch (IOException e) {
				log.error("IO exception:[{}]",e);
			}
		}
		return 0;
	}

	/**
	 * 返回PDF 最后一页的信息
	 * @param pdfData PDF byte值
	 * @return obj[0] 页数,obj[1] 最后一页的行数
	 */
	public static int[] getLastPage(byte[] pdfData){
		//2 加载PDF
		int[] obj = new int[2];
		PDDocument pdDocument;
		int pages;
		String content;
		try {
			pdDocument = PDDocument.load(pdfData);
			// 3 获取页码
			pages = pdDocument.getNumberOfPages();
			// 4 读文本内容
			PDFTextStripper stripper=new PDFTextStripper();
			// 5 设置按顺序输出,返回最后一页的内容
			stripper.setSortByPosition(true);
			stripper.setStartPage(pages);
			stripper.setEndPage(pages);
			content = stripper.getText(pdDocument);
			pdDocument.close();
			obj[0] = pages;
			obj[1] = getPDFLine(content);
		} catch (IOException e) {
			log.error("IO exception:[{}]",e);
		}
		return obj;
	}

	/**
	 * PDF 内容获取行数
	 */
	public static int getPDFLine(String content){
		int line = 0;
		char[] chars = content.toCharArray();
		for(int i=0;i<chars.length;i++){
			if(chars[i] == '\n'){
				line ++;
			}
		}
		return line;
	}

    /**
     * 根据pdf转为html文件
	 * @param writePath
     * @param content
	 */
	public static void replaceHtml(String  writePath,String content) {
		try {
			if (StringUtils.contains(writePath, ".pdf")) {
				writePath = StringUtils.substringBefore(writePath, ".pdf") + ".html";
			}
			Files.write(Paths.get(writePath), content.getBytes("UTF-8"));
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	/**
	 *
	 */
	public void downloadLocalPDF(byte[] response_str,String fileName) throws IOException {
		FileOutputStream fileOutputStream = new FileOutputStream(fileName);//存储路径，例：F://test//1.pdf
		IOUtils.write(response_str, fileOutputStream);
	}

	/**
	 * 辅助方法，byte数组保存为本地文件
	 * @param buf
	 * @param buf
	 * @param fileName
	 */
	public static String byte2File(byte[] buf, String fileName) {
		String filePath = "C:\\Users\\Duiba\\Desktop\\";
		BufferedOutputStream bos = null;
		FileOutputStream fos = null;
		File file;
		try {
			File dir = new File(filePath);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			file = new File(filePath + File.separator + fileName);
			fos = new FileOutputStream(file);
			bos = new BufferedOutputStream(fos);
			bos.write(buf);
		}catch (Exception e) {
			e.printStackTrace();
		}finally{
			if(bos != null) {
				try {
					bos.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			if (fos != null) {
				try {
					fos.close();
				}catch (IOException e){
					e.printStackTrace();
				}
			}
		}

		return filePath + File.separator + fileName;
	}

	private static class MyFontProvider extends XMLWorkerFontProvider {
		private String fontName = null;
		private String enCoding = null;

		public MyFontProvider(String fontName, String enCoding) {
			super(null, null);
			this.fontName = fontName;
			this.enCoding = enCoding;
		}

		@Override
		public Font getFont(final String fontname, final String encoding, final boolean embedded, final float size, final int style, final BaseColor color) {
			if (this.fontName == null) {
				return getFont(fontname, encoding, size, style);
			}

			BaseFont bf = null;
			try {
				bf = BaseFont.createFont(fontName, enCoding, BaseFont.NOT_EMBEDDED);
			} catch (DocumentException | IOException e) {
				throw new RuntimeException(e.getMessage(), e);
			}

			Font font = new Font(bf, size, style, color);
			font.setColor(color);
			return font;
		}
	}

}