/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;
import java.util.Objects;

public interface ActivityStatisticsConfig {
    public static final String TOTAL_VISIT_UV = "total_visit_uv_%s";
    public static final String DAY_VISIT_UV = "day_visit_uv_%s_%s";
    public static final String DAY_USER_VISIT_UV = "day_user_visit_uv_%s_%s_%s";
    public static final String VISIT_UV = "visit_uv_%s_%s";
    public static final String TOTAL_VISIT_PV = "total_visit_pv_%s";
    public static final String DAY_VISIT_PV = "day_visit_pv_%s_%s";
    public static final String TOTAL_GET_POINT_UV = "total_get_point_%s";
    public static final String USER_GET_POINT_UV = "user_get_point_uv_%s_%s";
    public static final String DAY_GET_POINT_UV = "day_get_point_uv_%s_%s";
    public static final String DAY_USER_GET_POINT_UV = "day_user_get_point_uv_%s_%s_%s";
    public static final String TOTAL_PRIZE_COUNT = "total_prize_count_%s";
    public static final String DAY_TOTAL_PRIZE_COUNT = "day_total_prize_count_%s_%s";

    public static String getTotalVisitUv(Long activityId) {
        return String.format(TOTAL_VISIT_UV, activityId);
    }

    public static String getDayVisitUv(Long activityId, Date day) {
        int dayNumber = Objects.nonNull(day) ? DateUtils.getDayNumber((Date)day) : DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_VISIT_UV, activityId, dayNumber);
    }

    public static String getDayUserVisitUv(Long activityId, Long userId) {
        int dayNumber = DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_USER_VISIT_UV, activityId, dayNumber, userId);
    }

    public static String getVisitUv(Long activityId, Long userId) {
        return String.format(DAY_VISIT_UV, activityId, userId);
    }

    public static String getTotalVisitPv(Long activityId) {
        return String.format(TOTAL_VISIT_PV, activityId);
    }

    public static String getDayVisitPv(Long activityId, Date day) {
        int dayNumber = Objects.nonNull(day) ? DateUtils.getDayNumber((Date)day) : DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_VISIT_PV, activityId, dayNumber);
    }

    public static String getTotalGetPointUv(Long activityId) {
        return String.format(TOTAL_GET_POINT_UV, activityId);
    }

    public static String getDayUsergetPointUv(Long activityId, Long userId) {
        return String.format(USER_GET_POINT_UV, activityId, userId);
    }

    public static String getDaygetPointUv(Long activityId, Date day) {
        int dayNumber = Objects.nonNull(day) ? DateUtils.getDayNumber((Date)day) : DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_GET_POINT_UV, activityId, dayNumber);
    }

    public static String getDayUserGetPointUv(Long activityId, Long userId) {
        int dayNumber = DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_USER_GET_POINT_UV, activityId, dayNumber, userId);
    }

    public static String getTotalPrizeCount(Long activityId) {
        return String.format(TOTAL_PRIZE_COUNT, activityId);
    }

    public static String getDayTotalPrizeCount(Long activityId, Date day) {
        int dayNumber = Objects.nonNull(day) ? DateUtils.getDayNumber((Date)day) : DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_TOTAL_PRIZE_COUNT, activityId, dayNumber);
    }
}

