/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.utils;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.zhongyan.activity.service.api.enums.ErrorCodeEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conditions {
    private static final Logger log = LoggerFactory.getLogger(Conditions.class);

    public static void expectFalse(boolean expression, String errorMessage) throws BizException {
        if (expression) {
            log.error("\u4e1a\u52a1\u5f02\u5e38message:{}", (Object)errorMessage);
            throw new BizException(errorMessage);
        }
    }

    public static void expectTrue(boolean expression, String errorMessage) throws BizException {
        if (!expression) {
            log.error("\u4e1a\u52a1\u5f02\u5e38:message:{}", (Object)errorMessage);
            throw new BizException(errorMessage);
        }
    }

    public static void expectTrue(boolean expression, ErrorCodeEnum errorCodeEnum) throws BizException {
        if (!expression) {
            log.error("\u4e1a\u52a1\u5f02\u5e38:message:{}", (Object)errorCodeEnum.errorMessage());
            throw new BizException(errorCodeEnum.errorMessage()).withCode(String.valueOf(errorCodeEnum.errorCode()));
        }
    }

    public static void expectFalse(boolean expression, ErrorCodeEnum errorCodeEnum) throws BizException {
        if (expression) {
            log.error("\u4e1a\u52a1\u5f02\u5e38:message:{}", (Object)errorCodeEnum.errorMessage());
            throw new BizException(errorCodeEnum.errorMessage()).withCode(String.valueOf(errorCodeEnum.errorCode()));
        }
    }
}

