package cn.com.duiba.zhongyan.activity.service.api.param.display;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Date 2022/7/29 14:54
 * @Author LuHui
 */
@Data
public class RemoteUserCheckPageParam extends PageRequest implements Serializable {
    private static final long serialVersionUID = -7678659851433538751L;

    /**
     * 活动id
     */
    @NotNull(message = "活动ID不能为空")
    private Long activityId;

    /**
     * 昵称
     */
    @Size(max = 50, message = "限制50字符")
    private String nickname;
    /**
     * 手机号
     */
    @Size(max = 50, message = "限制50字符")
    private String phone;
    /**
     * 专卖证号
     */
    @Size(max = 50, message = "限制50字符")
    private String number;
    /**
     * openId
     */
    @Size(max = 50, message = "限制50字符")
    private String openId;
    /**
     *  审核状态 1:全部 2:审核中 3:已审核
     */
    @NotNull(message = "审核状态不能为空，默认全部")
    private Integer status;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束世界
     */
    private Date endTime;
}
