package cn.com.duiba.zhongyan.activity.service.api.domain.dto.vote;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author xuanyu
 * @description: 作品记录
 * @date 2022/8/1 8:15 PM
 */
@Data
public class WorksRecordDTO implements Serializable {
    private static final long serialVersionUID = -5755333163446984010L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 零售店名
     */
    private String retailStoreName;

    /**
     * 作品图链接
     */
    private String worksImage;

    /**
     * 参赛编号
     */
    private Long worksNo;

    /**
     * 作品介绍
     */
    private String worksDescription;

    /**
     * 作品点赞数
     */
    private Long raiseNum;

    /**
     * 排名排序值
     */
    private Long rankOrder;

    /**
     * 作品排名
     */
    private Long worksRank;

    /**
     * 状态 0待审核 1通过 2拒绝
     * @see cn.com.duiba.zhongyan.activity.service.api.enums.WorksStatusEnum
     */
    private Integer status;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;
}
