package cn.com.duiba.zhongyan.activity.service.api.remoteservice.display;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.display.DisplayCheckRecordDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.display.DisplayCheckTemplateDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.display.DisplayIndexDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.display.DisplayUploadDetailDto;
import cn.com.duiba.zhongyan.activity.service.api.param.display.RemoteDisplayCheckRecordParam;
import cn.com.duiba.zhongyan.activity.service.api.param.display.RemoteDisplayQueryParam;
import cn.com.duiba.zhongyan.activity.service.api.param.display.VerifyAndSendParam;

import java.util.List;

/**
 * @Description
 * @Date 2022/8/2 13:50
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteDisplayService {


    /**
     * 首页
     * @param param
     * @return
     * @throws BizException
     */
    DisplayIndexDto index(RemoteDisplayQueryParam param) throws BizException;

    /**
     * 获取上传详情
     * @param param
     * @return
     */
    DisplayUploadDetailDto getUploadDetail(RemoteDisplayQueryParam param) throws BizException;


    /**
     * 上传
     * @param param
     * @return
     * @throws BizException
     */
    void upload(RemoteDisplayQueryParam param) throws BizException;

    /**
     * 确认
     * @param param
     * @return
     * @throws BizException
     */
    Long confirm(RemoteDisplayQueryParam param) throws BizException;

    /**
     * 申诉
     * @param param
     * @throws BizException
     */
    void appeal(RemoteDisplayQueryParam param) throws BizException;

    /**
     * 分页查询审核记录
     * @param param
     * @return
     */
    PageResponse<DisplayCheckRecordDto> pageDisplayCheckRecord(RemoteDisplayCheckRecordParam param);

    /**
     * 查询待审核用户id
     * @param displayCheckRecordDtoList
     * @return
     */
    List<Long> queryWaitCheckRecordUserIds(List<DisplayCheckRecordDto> displayCheckRecordDtoList);

    /**
     * 分页查询审核记录详情
     * @param param
     * @return
     */
    PageResponse<DisplayCheckRecordDto> pageDisplayCheckRecordDetail(RemoteDisplayCheckRecordParam param);

    /**
     * 更新审核记录
     * @param displayCheckRecordDto
     * @return
     */
    int updateCheckRecordById(DisplayCheckRecordDto displayCheckRecordDto);

    /**
     * 根据id查找审核记录
     * @param id
     * @return
     */
    DisplayCheckRecordDto getById(Long id);

    /**
     * 审核并发积分
     * @param verifyAndSendParam
     * @throws BizException
     */
    void verifyAndSendPoint(VerifyAndSendParam verifyAndSendParam) throws BizException;

    /**
     * 推送模版消息
     * @param displayCheckTemplateDto
     */
    void pushTemplateMessage(DisplayCheckTemplateDto displayCheckTemplateDto);
}
