package cn.com.duiba.zhongyan.activity.service.api.remoteservice.vote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.vote.ActivityWorksRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.vote.WorksRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.vote.*;

/**
 * @author xuanyu
 * @description: 作品投票服务
 * @date 2022/8/1 3:11 PM
 */
@AdvancedFeignClient
public interface RemoteVoteService {
    /**
     * 创建作品记录
     * @param createWorkRecordParam
     * @return
     */
    Integer createWorkRecord(CreateWorkRecordParam createWorkRecordParam) throws BizException;

    /**
     * 点赞投票
     * @param workVoteParam
     */
    void workVote(WorkVoteParam workVoteParam) throws BizException;

    /**
     * 查询作品列表
     * @param queryWorksListParam 查询参数
     * @return
     */
    PageResponse<WorksRecordDTO> queryWorksList(QueryWorksListParam queryWorksListParam);

    /**
     * 根据活动id和作品id查询作品详情(带排名)最大支持1500
     * @param activityId 活动id
     * @param workId 作品id
     * @return 作品详情
     */
    WorksRecordDTO getWorksRecordDTOWithRank(Long activityId,Long workId);

    /**
     * 查询指定活动指定用户剩余的点赞数
     * @param activityId 活动id
     * @param userId 用户id
     * @return 剩余投票数
     */
    Long userRemainVoteNum(Long activityId,Long userId);

    /**
     * 查询用户唯一的一个作品记录
     * @param activityId 活动id
     * @param userId 用户id
     * @return 作品信息
     */
    WorksRecordDTO getWorksRecordDTO(Long activityId,Long userId);

    /**
     * 分页查询数据
     * @param remoteServiceActivityVotePageParam
     * @return
     */
    PageResponse<ActivityWorksRecordDTO> getVotePageList(RemoteServiceActivityVotePageParam remoteServiceActivityVotePageParam);


    Boolean updateWorksState(Long activityId, Long id,Integer status) throws BizException;

    /**
     * 查询投票配置
     * @param activityId 活动id
     * @return
     * @throws BizException
     */
    DisplayActivityConfig getVoteConfig(Long activityId) throws BizException;

}
