package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.hutool.extra.emoji.EmojiUtil;
import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 月份题校验处理
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/9
 */
public class MonthChoiceHandler extends AbstractQuestionAnswerCheckHandler {

    private static final SimpleDateFormat MONTH = new SimpleDateFormat("yyyy-MM");

    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.MONTH_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        // 1. 可配置提示语，限制20
        Conditions.expectTrue(StringUtils.isBlank(param.getQuestionTip()) || EmojiUtil.removeAllEmojis(param.getQuestionTip()).length() <= 20, "题目["+param.getQuestionId()+"]:题目提示语错误-不能超过20个字符");
    }

    @Override
    String specificAnswerCheck(QuestionAnswerParam param) throws BizException {
        Integer questionId = param.getQuestionId();
        Conditions.expectTrue(param.getAnswerList().size() == 1, "题目["+ questionId +"]:答案错误-月份题只能存在一个答案");
        AnswerParam answer = param.getAnswerList().get(0);
        // 校验月份
        Conditions.expectTrue(StringUtils.isNotBlank(answer.getAnswer()), "题目["+ questionId +"]:答案错误-月份不能为空");
        Conditions.expectNotNull(getMonth(answer.getAnswer()), "题目["+ questionId +"]:答案错误-月份格式不正确");
        // 没什么要校验的
        return EMPTY_STRING;
    }

    private static Date getMonth(String dateStr) {
        if (StringUtils.isBlank(dateStr)) {
            return null;
        }
        synchronized (MONTH) {
            try {
                return MONTH.parse(dateStr);
            } catch (ParseException e) {
                return null;
            }
        }
    }

}
