package cn.com.duiba.zhongyan.activity.service.api.remoteservice.saleuser;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.DistinguishSaleCertificateImageLogDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteBaseSubmitAuditSheetParam;

/**
 * @author linzhou
 * @ClassName AuditSheetService.java
 * @createTime 2022年03月13日 16:03:00
 * @Description
 */
@AdvancedFeignClient
public interface RemoteAuditSheetService {

    /**
     * 提交审核
     *
     * @param param
     * @return
     */
    Long submitAuditSheet(RemoteBaseSubmitAuditSheetParam param) throws BizException;

    /**
     * 识别专卖证图片信息
     *
     * @param url
     * @return
     * @throws BizException
     */
    DistinguishSaleCertificateImageLogDTO distinguishSaleCertificateImage(String url) throws BizException;
}
