package cn.com.duiba.zhongyan.activity.service.api.remoteservice.scanCode;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.param.scanCode.RemoteClaimStatisticsParam;
import cn.com.duiba.zhongyan.activity.service.api.param.scanCode.RemoteDrawStatisticsParam;
import cn.com.duiba.zhongyan.activity.service.api.param.scanCode.RemoteLastParticipateParam;

/**
 * @author xiaotian
 * @description: 扫码统计对外服务
 * @date 2022/03/18 6:07 下午
 */
@AdvancedFeignClient
public interface RemoteScanCodeStitisticsService {

    /**
     * 更新最后的访问时间
     * @param remoteLastParticipateParam
     * @return
     */
    boolean updateLastParticipateTime(RemoteLastParticipateParam remoteLastParticipateParam);


    /**
     * 抽奖更新统计数据
     *
     * @param remoteDrawStatisticsParam
     * @return
     */
    boolean draw(RemoteDrawStatisticsParam remoteDrawStatisticsParam);

    /**
     * 兑奖更新统计数据
     *
     * @param remoteClaimStatisticsParam
     * @return
     */
    boolean claim(RemoteClaimStatisticsParam remoteClaimStatisticsParam);
}
