package cn.com.duiba.zhongyan.activity.service.api.enums.record;

import java.util.Objects;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/18
 */

public enum PointRecordChangeTypeEnum {
    DEFAULT(-1,"未知"),
    CODE(1,"扫码"),
    EXCHANGE(3,"兑换奖品"),
    LOTTERY(2,"抽奖"),
    PRIZE(4,"中奖"),
    ADMIN(5,"后台变更"),
    ;

    private Integer type;

    private String desc;
    PointRecordChangeTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getType() {
        return type;
    }

    public static PointRecordChangeTypeEnum getByType(Integer type){
        for(PointRecordChangeTypeEnum changeTypeEnum : PointRecordChangeTypeEnum.values()){
            if(changeTypeEnum.getType().equals(type)){
                return changeTypeEnum;
            }
        }
        return PointRecordChangeTypeEnum.DEFAULT;
    }
}
