package cn.com.duiba.zhongyan.activity.service.api.utils;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ExpireTime {

    private final Date expire;

    /**
     * 使用时间戳创建对象
     *
     * @param timestamp
     * @return
     */
    public static ExpireTime of(long timestamp) {
        return new ExpireTime(new Date(timestamp));
    }

    /**
     * 使用java.util.Date创建对象
     *
     * @param date
     * @return
     */
    public static ExpireTime of(Date date) {
        return new ExpireTime(date);
    }

    /**
     * 使用java.time.LocalDateTime创建对象
     *
     * @param dateTime
     * @return
     */
    public static ExpireTime of(LocalDateTime dateTime) {
        return new ExpireTime(Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant()));
    }

    /**
     * 使用失效时长创建对象
     *
     * @param timeout 失效时间
     * @param unit    单位
     * @return
     */
    public static ExpireTime duration(long timeout, TimeUnit unit) {
        return new ExpireTime(new Date(unit.toMillis(timeout) + System.currentTimeMillis()));
    }

    private ExpireTime(Date expire) {
        this.expire = expire;
    }

    public long getTimestamp() {
        return expire.getTime();
    }

    public Date getDate() {
        return expire;
    }

    public LocalDateTime getDateTime() {
        return expire.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }
}
