package cn.com.duiba.zhongyan.activity.service.api.domain.dto.record;

import com.alibaba.excel.annotation.ExcelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author wangxukai
 * @description 多维度用户积分数据
 * @date ：Created in 2022/3/19
 */
@Data
public class ScanCodePageRecordDto implements Serializable {

    /**
     * 积分账户id
     */
    private Long pointId;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * openId
     */
    @ExcelProperty("OpenId")
    private String openId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * avatar
     */
    @ExcelProperty("用户头像")
    private String avatar;

    /**
     * 昵称
     */
    @ExcelProperty("用户名称")
    private String nick;

    /**
     * 手机号
     */
    @ExcelProperty("手机号码")
    private String phone;

    /**
     * 累计活动积分
     */
    @ExcelProperty("累计获得积分")
    private Long totalPoint;

    /**
     * 扫码获得积分
     */
    @ExcelProperty("累计获得积分")
    private Long scanPoint;

    /**
     * 中奖获得积分
     */
    @ExcelProperty("中奖获得积分")
    private Long winPoint;

    /**
     * 后台增加积分
     */
    @ExcelProperty("后台增加积分")
    private Long backAddPoint;

    /**
     * 后台减少积分
     */
    @ExcelProperty("后台消耗积分")
    private Long backReducePoint;

    /**
     * 累计消耗积分
     */
    @ExcelProperty("累计消耗积分")
    private Long totalConsumePoint;

    /**
     * 当前剩余积分
     */
    @ExcelProperty("当前剩余积分")
    private Long residuePoint;

    /**
     * 累计抽奖次数
     */
    @ExcelProperty("累计抽奖次数")
    private Long totalDrawTimes;

    /**
     * 累计中奖次数
     */
    @ExcelProperty("累计中奖次数")
    private Long totalWinTimes;

    /**
     * 累计中奖率
     */
    @ExcelProperty("累计中奖率")
    private Long winRate;

    /**
     * 累计兑奖次数
     */
    @ExcelProperty("累计兑奖次数")
    private Long claimPrizeTimes;

    /**
     * 累计实物奖品金额
     */
    @ExcelProperty("累计实物奖金余额")
    private Long totalPrizeAmount;

    /**
     * 最后参与时间
     */
    @ExcelProperty("最后参与时间")
    private Date lastParticipateTime;

}
