/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;
import java.util.Date;

public interface ActivityStatisticsConfig {
    public static final String TOTAL_VISIT_UV = "total_visit_uv_%s";
    public static final String DAY_VISIT_UV = "day_visit_uv_%s_%s";
    public static final String DAY_USER_VISIT_UV = "day_user_visit_uv_%s_%s_%s";
    public static final String VISIT_UV = "visit_uv_%s_%s";
    public static final String TOTAL_VISIT_PV = "total_visit_pv_%s";
    public static final String DAY_VISIT_PV = "day_visit_pv_%s_%s";

    public static String getTotalVisitUv(Long activityId) {
        return String.format(TOTAL_VISIT_UV, activityId);
    }

    public static String getDayVisitUv(Long activityId) {
        int dayNumber = DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_VISIT_UV, activityId, dayNumber);
    }

    public static String getDayUserVisitUv(Long activityId, Long userId) {
        int dayNumber = DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_USER_VISIT_UV, activityId, dayNumber, userId);
    }

    public static String getVisitUv(Long activityId, Long userId) {
        return String.format(DAY_VISIT_UV, activityId, userId);
    }

    public static String getTotalVisitPv(Long activityId) {
        return String.format(TOTAL_VISIT_PV, activityId);
    }

    public static String getDayVisitPv(Long activityId) {
        int dayNumber = DateUtils.getDayNumber((Date)new Date());
        return String.format(DAY_VISIT_PV, activityId, dayNumber);
    }
}

