package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;
import java.util.Objects;

public interface ActivityStatisticsConfig {

    /**
     * 访问uv总量key-单个活动纬度
     */
    String TOTAL_VISIT_UV = "total_visit_uv_%s";
    static String getTotalVisitUv(Long activityId) {
        return String.format(TOTAL_VISIT_UV, activityId);
    }

    /**
     * 每日访问uv量key-单个活动纬度
     */
    String DAY_VISIT_UV = "day_visit_uv_%s_%s";
    static String getDayVisitUv(Long activityId,Date day) {
        int dayNumber;
        if(Objects.nonNull(day)){
            dayNumber = DateUtils.getDayNumber(day);
        }else {
            dayNumber = DateUtils.getDayNumber(new Date());
        }
        return String.format(DAY_VISIT_UV,activityId, dayNumber);
    }

    /**
     * 限制用户日纬度uv访问量-用户日纬度
     */
    String DAY_USER_VISIT_UV = "day_user_visit_uv_%s_%s_%s";
    static String getDayUserVisitUv(Long activityId,Long userId){
        int dayNumber = DateUtils.getDayNumber(new Date());
        return String.format(DAY_USER_VISIT_UV, activityId, dayNumber, userId);
    }

    /**
     * 限制单个用户访问量key
     */
    String VISIT_UV = "visit_uv_%s_%s";
    static String getVisitUv(Long activityId,Long userId) {
        return String.format(DAY_VISIT_UV, activityId,userId);
    }

    /**
     * 访问pv总量key-活动纬度
     */
    String TOTAL_VISIT_PV = "total_visit_pv_%s";
    static String getTotalVisitPv(Long activityId) {
        return String.format(TOTAL_VISIT_PV, activityId);
    }

    /**
     * 每日访问pv量key-活动纬度
     */
    String DAY_VISIT_PV = "day_visit_pv_%s_%s";
    static String getDayVisitPv(Long activityId,Date day) {
        int dayNumber;
        if(Objects.nonNull(day)){
            dayNumber = DateUtils.getDayNumber(day);
        }else {
            dayNumber = DateUtils.getDayNumber(new Date());
        }
        return String.format(DAY_VISIT_PV,activityId, dayNumber);
    }


    /**
     * 活动积分获取uv-单个活动纬度
     */
    String TOTAL_GET_POINT_UV = "total_get_point_%s";
    static String getTotalGetPointUv(Long activityId) {
        return String.format(TOTAL_GET_POINT_UV, activityId);
    }

    /**
     * 每日活动积分获取uv-单个活动纬度
     */
    String DAY_GET_POINT_UV = "day_get_point_uv_%s_%s";
    static String getDaygetPointUv(Long activityId,Date day) {
        int dayNumber;
        if(Objects.nonNull(day)){
            dayNumber = DateUtils.getDayNumber(day);
        }else {
            dayNumber = DateUtils.getDayNumber(new Date());
        }
        return String.format(DAY_GET_POINT_UV,activityId, dayNumber);
    }

    /**
     * 限制用户日纬度活动积分获取uv访问量-用户日纬度
     */
    String DAY_USER_GET_POINT_UV = "day_user_get_point_uv_%s_%s_%s";
    static String getDayUserGetPointUv(Long activityId,Long userId){
        int dayNumber = DateUtils.getDayNumber(new Date());
        return String.format(DAY_USER_GET_POINT_UV, activityId, dayNumber, userId);
    }

    /**
     * 活动奖品发放量 （总）
     */
    String TOTAL_PRIZE_COUNT = "total_prize_count_%s";
    static String getTotalPrizeCount(Long activityId) {
        return String.format(TOTAL_PRIZE_COUNT, activityId);
    }

    /**
     * 活动奖品发放量 （单天）
     */
    String DAY_TOTAL_PRIZE_COUNT = "day_total_prize_count_%s_%s";
    static String getDayTotalPrizeCount(Long activityId,Date day) {
        int dayNumber;
        if(Objects.nonNull(day)){
            dayNumber = DateUtils.getDayNumber(day);
        }else {
            dayNumber = DateUtils.getDayNumber(new Date());
        }
        return String.format(DAY_TOTAL_PRIZE_COUNT,activityId, dayNumber);
    }

}
