package cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @ClassName SaleCertificateCheckEntity.java
 * @createTime 2022年03月11日 17:29:00
 * @author linzhou
 * @Description 
 */

/**
 * 专卖证审核资料
 */
@Data
public class SaleCertificateCheckDTO implements Serializable {
    private Long id;

    /**
     * 审核单id
     */
    private Long auditSheetId;

    /**
     * 专卖证号
     */
    private String saleCertificateNo;

    /**
     * 专卖证图片
     */
    private String saleCertificateImage;

    /**
     * 订单首页照片
     */
    private String orderImage;

    /**
     * 姓名
     */
    private String name;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 业态类型
     */
    private String type;

    /**
     * 有效期开始
     */
    private Date startTime;

    /**
     * 有效期结束
     */
    private Date endTime;

    /**
     * 是否是组长 1:是 0:不是
     */
    private Integer groupLeader;

    /**
     * 省
     */
    private Long province;

    /**
     * 市
     */
    private Long city;

    /**
     * 区
     */
    private Long area;

    /**
     * 详细地址
     */
    private Long address;

    /**
     * 创建时间/提交时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    /**
     * 创建者/申请人id
     */
    private Long createdBy;
}