/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.utils;

import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityDetailExcelDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.SurveyDataExcelDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinPrizeHeadExcelDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinnerRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.enums.PrizeStatusEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerPageParam;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerPageRecordParam;
import cn.com.duiba.zhongyan.activity.service.api.param.DataStatisticsParam;
import cn.com.duiba.zhongyan.activity.service.api.param.OptionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.SurveyDataParam;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.metadata.BaseRowModel;
import com.alibaba.excel.metadata.Sheet;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ExcelExportUtil {
    public static final Logger logger = LoggerFactory.getLogger(ExcelExportUtil.class);
    public static final String outPath = "";
    public static ExcelWriter writer = null;
    public static WriteSheet writeSheet = null;
    public static OutputStream outputStream = null;
    public static final List<String> answerPageHeadList = new ArrayList<String>(){
        {
            this.add("OpenID");
            this.add("UnionID");
            this.add("\u7528\u6237\u6635\u79f0");
            this.add("\u7b54\u9898\u65f6\u95f4");
            this.add("\u6240\u5c5e\u5730\u533a");
            this.add("\u7528\u6237\u6807\u7b7e");
            this.add("\u7b54\u9898\u65f6\u957f");
        }
    };

    public void initAnswerExport(Integer questionNum, OutputStream out) {
        ArrayList<ArrayList> headList = new ArrayList<ArrayList>();
        headList.add(Lists.newArrayList((Object[])new String[]{"OpenID"}));
        headList.add(Lists.newArrayList((Object[])new String[]{"UnionID"}));
        headList.add(Lists.newArrayList((Object[])new String[]{"\u7528\u6237\u6635\u79f0"}));
        headList.add(Lists.newArrayList((Object[])new String[]{"\u7b54\u9898\u65f6\u95f4"}));
        headList.add(Lists.newArrayList((Object[])new String[]{"\u6240\u5c5e\u5730\u533a"}));
        headList.add(Lists.newArrayList((Object[])new String[]{"\u7528\u6237\u6807\u7b7e"}));
        headList.add(Lists.newArrayList((Object[])new String[]{"\u7b54\u9898\u65f6\u957f"}));
        outputStream = out;
        for (int i = 1; i <= questionNum; ++i) {
            headList.add(Lists.newArrayList((Object[])new String[]{String.format("\u9898\u76ee%s", i)}));
            headList.add(Lists.newArrayList((Object[])new String[]{String.format("\u7b54\u6848%s", i)}));
        }
        writer = EasyExcelFactory.write((OutputStream)outputStream).head(headList).build();
        writeSheet = EasyExcelFactory.writerSheet((String)"\u7b54\u5377\u5217\u8868").build();
    }

    public void close() {
        try {
            if (Objects.nonNull(writer)) {
                writer.finish();
            }
            if (Objects.nonNull(outputStream)) {
                outputStream.close();
            }
        }
        catch (IOException e) {
            logger.error("\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
        }
    }

    public void exportAnswerPage(List<AnswerPageRecordParam> answerPageRecordParamList) throws Exception {
        List<Object> list = new ArrayList();
        if (CollectionUtils.isNotEmpty(answerPageRecordParamList)) {
            list = answerPageRecordParamList.stream().map(answerPageRecord -> {
                ArrayList<String> row = new ArrayList<String>();
                row.add(answerPageRecord.getOpenId());
                row.add(answerPageRecord.getUnionId());
                row.add(answerPageRecord.getNick());
                row.add(answerPageRecord.getAnswerTime());
                row.add(answerPageRecord.getRegion());
                row.add(answerPageRecord.getUserTagStr());
                row.add(String.format("%s\u79d2", answerPageRecord.getAnswerDuration() / 1000L));
                AnswerPageParam answerPage = (AnswerPageParam)JSONObject.parseObject((String)answerPageRecord.getAnswerContent(), AnswerPageParam.class);
                List<QuestionAnswerParam> questionList = answerPage.getQuestionList();
                questionList.forEach(question -> {
                    row.add(question.getTitle());
                    List<OptionParam> option = question.getOption();
                    Map optionParamMap = option.stream().collect(Collectors.toMap(OptionParam::getOptionId, Function.identity(), (v1, v2) -> v1));
                    String answer = question.getAnswerList().stream().map(answerContent -> {
                        if (question.getType() != 2) {
                            if (StringUtils.isBlank((CharSequence)answerContent.getRequiredAnswer())) {
                                OptionParam optionParam = (OptionParam)optionParamMap.get(answerContent.getAnswer());
                                return String.format("%s.%s", answerContent.getAnswer(), optionParam.getOptionContent());
                            }
                            return String.format(answerContent.getAnswer() + "-%s", answerContent.getRequiredAnswer());
                        }
                        return answerContent.getAnswer();
                    }).collect(Collectors.joining(";"));
                    row.add(answer);
                });
                return row;
            }).collect(Collectors.toList());
        }
        writer.write(list, writeSheet);
    }

    public void winPrizeUserExport(List<WinnerRecordDTO> winnerRecordDtoList) {
        ArrayList data = new ArrayList();
        winnerRecordDtoList.forEach(prize -> {
            WinPrizeHeadExcelDTO winPrizeHeadExcelDTO = new WinPrizeHeadExcelDTO();
            winPrizeHeadExcelDTO.setOpenId(prize.getOpenId());
            winPrizeHeadExcelDTO.setUnionID(prize.getUnionId());
            winPrizeHeadExcelDTO.setNick(prize.getNickName());
            winPrizeHeadExcelDTO.setPrize(prize.getPrizeName());
            winPrizeHeadExcelDTO.setPrizeStatus(PrizeStatusEnum.getDescByStatus(prize.getPrizeStatus()));
            winPrizeHeadExcelDTO.setReceiveTime(DateUtils.getSecondStr((Date)prize.getReceiveTime()));
            winPrizeHeadExcelDTO.setOrderId(prize.getOrderId());
            winPrizeHeadExcelDTO.setUsername(prize.getUsername());
            winPrizeHeadExcelDTO.setPhone(prize.getPhone());
            winPrizeHeadExcelDTO.setAddress(prize.getAddress());
            data.add(winPrizeHeadExcelDTO);
        });
        writer.write(data, writeSheet);
    }

    public static void activityDetailExport(List<DataStatisticsParam> dataStatisticsParams) {
        ArrayList data = new ArrayList();
        dataStatisticsParams.forEach(x -> {
            ActivityDetailExcelDTO activityDetailExcelDTO = new ActivityDetailExcelDTO();
            activityDetailExcelDTO.setDate(DateUtils.getDayStr((Date)x.getSyncTime()));
            activityDetailExcelDTO.setJoinPv(Objects.isNull(x.getJoinPv()) ? 0L : x.getJoinPv());
            activityDetailExcelDTO.setJoinUv(Objects.isNull(x.getJoinUv()) ? 0L : x.getJoinUv());
            activityDetailExcelDTO.setVisitPv(Objects.isNull(x.getVisitPv()) ? 0L : x.getVisitPv());
            activityDetailExcelDTO.setVisitUv(Objects.isNull(x.getVisitUv()) ? 0L : x.getVisitUv());
            activityDetailExcelDTO.setSubmitCount(Objects.isNull(x.getSubmitCount()) ? 0L : x.getSubmitCount());
            activityDetailExcelDTO.setJoinRatio(StringUtils.isBlank((CharSequence)x.getJoinRatio()) ? "0.00%" : x.getJoinRatio());
            activityDetailExcelDTO.setCompletion(StringUtils.isBlank((CharSequence)x.getCompletion()) ? "0.00%" : x.getCompletion());
            data.add(activityDetailExcelDTO);
        });
        writer.write(data, writeSheet);
    }

    public static void surveyDataExport(List<SurveyDataParam> surveyDataParams) {
        ArrayList data = new ArrayList();
        surveyDataParams.forEach(x -> {
            SurveyDataExcelDTO surveyDataExcelDTO = new SurveyDataExcelDTO();
            surveyDataExcelDTO.setOption(x.getOption());
            surveyDataExcelDTO.setCount(Objects.isNull(x.getCount()) ? 0L : x.getCount());
            surveyDataExcelDTO.setTitle(x.getTitle());
            surveyDataExcelDTO.setRatio(StringUtils.isBlank((CharSequence)x.getRatio()) ? "0.0%" : x.getRatio());
            data.add(surveyDataExcelDTO);
        });
        writer.write(data, writeSheet);
    }

    public void init(OutputStream out, String sheetName) {
        outputStream = out;
        writer = EasyExcelFactory.write((OutputStream)outputStream, WinPrizeHeadExcelDTO.class).build();
        writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
    }

    public void initSurveyData(OutputStream out, String sheetName) {
        outputStream = out;
        writer = EasyExcelFactory.write((OutputStream)outputStream, SurveyDataExcelDTO.class).build();
        writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
    }

    public void initActivity(OutputStream out, String sheetName) {
        outputStream = out;
        writer = EasyExcelFactory.write((OutputStream)outputStream, ActivityDetailExcelDTO.class).build();
        writeSheet = EasyExcelFactory.writerSheet((String)sheetName).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeWithTemplateAndSheet(String fileName, List<? extends BaseRowModel> data, Sheet sheet) {
        if (CollectionUtils.isEmpty(data)) {
            return;
        }
        sheet = sheet != null ? sheet : new Sheet(0, 1);
        sheet.setClazz(data.get(0).getClass());
        OutputStream outputStream = null;
        ExcelWriter writer = null;
        try {
            outputStream = new FileOutputStream(outPath + fileName);
            writer = EasyExcelFactory.getWriter((OutputStream)outputStream);
            writer.write(data, sheet);
        }
        catch (FileNotFoundException e) {
            logger.error("\u627e\u4e0d\u5230\u6587\u4ef6\u6216\u6587\u4ef6\u8def\u5f84\u9519\u8bef, \u6587\u4ef6\uff1a{}", (Object)(outPath + fileName));
        }
        finally {
            try {
                if (writer != null) {
                    writer.finish();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                logger.error("excel\u6587\u4ef6\u5bfc\u51fa\u5931\u8d25, \u5931\u8d25\u539f\u56e0\uff1a{}", (Throwable)e);
            }
        }
    }
}

