package cn.com.duiba.zhongyan.activity.service.api.param;

import cn.com.duiba.zhongyan.activity.service.api.base.BasePageParam;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author xuanyu
 * @description: 答卷查询参数
 * @date 2021/11/26 10:24 上午
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AnswerPageQueryParam extends BasePageParam implements Serializable {

    private static final long serialVersionUID = 6751148507673658274L;

    /**
     * id
     */
    private Long id;

    /**
     * 用户id列表，传了这个参数满足其余条件的情况下进行批量查询
     */
    private List<Long> userIdList;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * openId
     */
    private String openId;

    /**
     * unionId
     */
    private String unionId;

    /**
     * 区等于
     */
    private String region;

    /**
     * 区 模糊匹配
     */
    private String regionLike;

    /**
     * 包含这些区之一的结果
     */
    private List<String> regionList;

    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 用户昵称
     */
    private String nick;

    /**
     * 答题开始时间 秒级时间戳
     */
    private Date startTime;

    /**
     * 答题结束时间 秒级时间戳
     */
    private Date endTime;

    /**
     * 答题时长起始
     */
    private Long longTimeStart;

    /**
     * 答题时长起始
     */
    private Long longTimeEnd;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;

    /**
     * 是否中奖
     */
    private Byte win;
}
