/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.base;

import java.io.Serializable;

public class JsonResult<T>
implements Serializable {
    private static final long serialVersionUID = -4013056288290917503L;
    private static final String DEFAULT_FAIL_CODE = "-1";
    private static final String DEFAULT_SUCCESS_CODE = "0";
    private boolean success;
    private String message;
    private T data;
    private String code;

    private JsonResult() {
    }

    public static <T> JsonResult<T> fail(String code, String desc) {
        JsonResult<T> result = new JsonResult<T>();
        result.setSuccess(false);
        result.setCode(code);
        result.setMessage(desc);
        return result;
    }

    public static <T> JsonResult<T> fail(String desc) {
        return JsonResult.fail(DEFAULT_FAIL_CODE, desc);
    }

    public static <T> JsonResult<T> fail(String code, String desc, T data) {
        JsonResult<T> result = new JsonResult<T>();
        result.setSuccess(false);
        result.setCode(code);
        result.setMessage(desc);
        result.setData(data);
        return result;
    }

    public static <T> JsonResult<T> fail(String desc, T data) {
        return JsonResult.fail(DEFAULT_FAIL_CODE, desc, data);
    }

    public static <T> JsonResult<T> success(String code, T data) {
        JsonResult<T> result = new JsonResult<T>();
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setMessage("OK");
        return result;
    }

    public static <T> JsonResult<T> success(T data) {
        return JsonResult.success(DEFAULT_SUCCESS_CODE, data);
    }

    public static <T> JsonResult<T> success() {
        return JsonResult.success(DEFAULT_SUCCESS_CODE, null);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}

