package cn.com.duiba.zhongyan.activity.service.api.param.saleuser;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author linzhou
 * @ClassName GetAppealListParam.java
 * @createTime 2022年03月09日 17:04:00
 * @Description
 */
@Data
public class RemoteGetCheckListParam extends PageRequest {

    /**
     * 审核单id
     */
    private Long id;

    /**
     * 用户名
     */
    private String cName;

    /**
     * 手机号
     */
    private String mobile;
    /**
     * 姓名
     */
    private String name;

    /**
     * 店铺名称
     */
    private String shopName;
    /**
     * 省
     */
    private String province;

    /**
     * 市
     */
    private String city;

    /**
     * 区
     */
    private String area;
    /**
     * 审核单状态;1:待审核 2:审核通过 3:审核拒绝
     */
    private Integer checkStatus;

    /**
     * 专卖证号
     */
    private String saleCertificateNo;
    /**
     * 提交时间开始
     */
    private Date gmtCreateStart;
    /**
     * 提交时间结束
     */
    private Date gmtCreateEnd;

    /**
     * 审核时间开始
     */
    private Date checkTimeStart;
    /**
     * 审核时间结束
     */
    private Date checkTimeEnd;

    /**
     * 审核类型
     */
    private String checkType;


    private List<Long> createBys;

    private SortParam sortParam;

    public String getOrderBy() {
        if (Objects.isNull(sortParam)) {
            return " order by gmtCreate desc,id desc";
        }
        String orderBy = sortParam.getOrderBy();
        return StringUtils.isBlank(orderBy) ? " order by gmtCreate desc,id desc" : orderBy;
    }
}
