package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.param.RemoteNestingActivitySaveParam;

/**
 * 远程活动嵌套服务
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/10
 */
@AdvancedFeignClient
public interface RemoteActivityNestingService {

    /**
     * 新增嵌套活动
     *
     * @param remoteParam
     * @return
     * @throws BizException
     */
    Long nestingActivity(RemoteNestingActivitySaveParam remoteParam) throws BizException;

    /**
     * 查询嵌套活动的主活动
     *
     * @param nestingId 活动id
     * @return
     * @throws BizException
     */
    Long queryMainActivityId(Long nestingId) throws BizException;

    /**
     * 查询活动的嵌套活动
     *
     * @param activityId 活动id
     * @return
     * @throws BizException
     */
    Long queryNestingActivityId(Long activityId) throws BizException;

}
