package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.OptionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import org.apache.commons.lang3.StringUtils;

/**
 * 下拉题校验处理
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/9
 */
public class DropDownChoiceHandler extends AbstractQuestionAnswerCheckHandler {

    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.DROP_DOWN_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        commonChoiceQuestionCheck(param, 10);
        // 1. 可配置提示语，限制20
        Conditions.expectTrue(StringUtils.isBlank(param.getQuestionTip()) || param.getQuestionTip().length() <= 20, "题目["+param.getQuestionId()+"]:题目提示语错误-不能超过20个字符");
    }

    @Override
    void specificAnswerCheck(QuestionAnswerParam param) throws BizException {
        Integer questionId = param.getQuestionId();
        // 1. 单选题只能有一个答案
        Conditions.expectTrue(param.getAnswerList().size() == 1, "题目["+ questionId +"]:答案错误-下拉只能选择一个答案");
        // 2. 答案要在题目里面
        checkOptionParam(param.getOption(), questionId,10);
        AnswerParam answer = param.getAnswerList().get(0);
        Conditions.expectTrue(StringUtils.isNotBlank(answer.getAnswer()), "题目["+ questionId +"]:答案错误-答案不能为空");

        OptionParam option = param.getOption().stream().filter(opt -> answer.getAnswer().equals(opt.getOptionId())).findFirst().orElse(null);
        Conditions.expectNotNull(option, "题目["+ questionId +"]:答案错误-答案不在选项中");
    }

}
