package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import org.apache.commons.lang3.StringUtils;

/**
 * 填空题校验处理
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/9
 */
public class FillBlanksHandler extends AbstractQuestionAnswerCheckHandler {

    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.FILL_BLANKS;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        // 1. 可配置提示语，限制20
        Conditions.expectTrue(StringUtils.isBlank(param.getQuestionTip()) || param.getQuestionTip().length() <= 20, "题目["+param.getQuestionId()+"]:题目提示语错误-不能超过20个字符");
    }

    @Override
    void specificAnswerCheck(QuestionAnswerParam param) throws BizException {
        Integer questionId = param.getQuestionId();
        Conditions.expectTrue(param.getAnswerList().size() == 1, "题目["+ questionId +"]:答案错误-填空题只能存在一个答案");
        AnswerParam answer = param.getAnswerList().get(0);
        // 1. 不超过50个字符
        Conditions.expectTrue(StringUtils.isNotBlank(answer.getAnswer()) && answer.getAnswer().length() <= 50, "题目["+ questionId +"]:答案错误-填空框不能为空且不超过50个字符");
    }

}
