package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.CommonStateEnum;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.OptionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 多选题校验处理
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/9
 */
public class MultipleChoiceHandler extends AbstractQuestionAnswerCheckHandler {

    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.MULTIPLE_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        commonChoiceQuestionCheck(param, 10);
    }

    @Override
    void specificAnswerCheck(QuestionAnswerParam param) throws BizException {
        Integer questionId = param.getQuestionId();
        checkOptionParam(param.getOption(), questionId,10);
        Map<String, OptionParam> optionMap = param.getOption().stream().collect(Collectors.toMap(OptionParam::getOptionId, Function.identity()));

        for (AnswerParam answer : param.getAnswerList()) {
            Conditions.expectTrue(StringUtils.isNotBlank(answer.getAnswer()), "题目["+ questionId +"]:答案错误-答案不能为空");
            OptionParam option = optionMap.get(answer.getAnswer());
            Conditions.expectNotNull(option, "题目["+ questionId +"]:答案错误-答案不在选项中");
            // 校验必填框
            if (CommonStateEnum.STATE_ZERO.getState().equals(option.getAllowWrite())
                    && CommonStateEnum.STATE_ZERO.getState().equals(option.getTipStatus())) {
                Conditions.expectNotNull(StringUtils.isNotBlank(answer.getRequiredAnswer()) && answer.getRequiredAnswer().length() <= 50, "题目["+ questionId +"]:答案错误-填空框不能为空且不超过50个字符");
            }
        }

    }

}
