package cn.com.duiba.zhongyan.activity.service.api.domain.dto;

import cn.com.duiba.zhongyan.activity.service.api.enums.ActivityStateEnum;
import cn.com.duiba.zhongyan.activity.service.api.enums.DeleteFlagEnum;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author XingZhuang
 * @description 活动
 * @date 2021/11/25  4:19 下午
 */

@Data
public class ActivityDTO implements Serializable {

    private static final long serialVersionUID = 3016082900845971969L;

    /**
     * 活动id
     */
    private Long id;

    /**
     * 活动名称
     */
    private String title;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 活动类型
     * @see cn.com.duiba.zhongyan.activity.service.api.enums.ActivityTemplateTypeEnum
     */
    private String templateType;

    /**
     * @see ActivityStateEnum
     */
    private Integer state;

    /**
     * @see DeleteFlagEnum
     */
    private Integer deleted;

    /**
     * 自定义配置
     */
    private String attributes;

    /**
     * 创建日期
     */
    private Date gmtCreate;

    /**
     * 修改日期
     */
    private Date gmtModified;

    /**
     * 是否返还预占库存
     * @see cn.com.duiba.cloud.biz.tool.constants.BaseConstant#IS_TRUE
     * @see cn.com.duiba.cloud.biz.tool.constants.BaseConstant#IS_FALSE
     */
    private Integer isRollbackStock;

    /**
     * 活动场景 0-单独投放 1-嵌入其他活动
     */
    private Integer activityScenes;
    /**
     * 绑定活动ID
     */
    private Long bindId;

}
