package cn.com.duiba.zhongyan.activity.service.api.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.hutool.core.util.StrUtil;
import lombok.Getter;

/**
 * @author LuHui
 * @description
 * @date 2021/11/25  16:30
 */
@Getter
public enum ErrorCodeEnum implements BizError {

    /**
     *
     */
    FREQUENT_OPERATION(000001,"请求太频繁啦,请稍后再试"),

    PARAM_ERROR(100100, "参数错误"),
    ACTIVITY_NOT_EXIT(100101, "该活动不存在"),
    ACTIVITY_NOT_START(100102, "活动尚未开始"),
    ACTIVITY_ALREADY_END(100103, "活动已结束"),
    ANSWER_VERITY_AREA(100104, "仅限部门地区可参与"),
    ANSWER_VERIFY_USER(100105, "该活动仅限零售户参与"),
    ANSWER_VERITY(100106, "请先完成当前题目"),
    ANSWER_RECORD_NOT_EXIT(100107, "答题记录不存在"),
    ANSWER_NOT_COMMIT(100108, ""),
    USER_NOT_EXIT(100109,"用户不存在"),
    USER_NOT_SUBSCRIBE(100110,"用户未关注"),
    LIMIT_DRAW_TIME_DAY(100111,"抽奖次数达到每日上限"),
    POINT_NOT_ENOUGH(100112,"积分不足"),
    POINT_NOT_IN_CONDITION(100113,"不可中奖时段或者不可中奖地市"),
    POINT_BLACK(100114,"黑名单"),
    POINT_GOODS_REPERTORY_NOT_ENOUGH(100115,"奖品库存不足-抽奖"),
    POINT_WIN_TIME_LIMIT(100116,"中奖总次数达到上限"),
    POINT_GOODS_WIN_TIME_LIMIT(100117,"抽中的奖品达到单奖品上限"),
    POINT_GOODS_EXCHANGE_TIME_LIMIT(100118,"是否超过同款奖品限兑次数"),
    POINT_THANK(100119,"谢谢参与"),
    POINT_CLIAM_CODE_ENUM_GOODS_REPERTORY_NOT_ENOUGH(100120,"奖品库存不足-兑奖"),
    POINT_CLIAM_PERSON(100121,"每人限兑-兑奖"),
    POINT_CLIAM_DAY(100122,"每日限兑-兑奖"),
    POINT_ORDER_CREATE_SAME(100123,"地址手机号存在重复"),
    PART_USER_JOIN(100124, "仅限部分用户参与"),

    NOT_OPERATION(200100, "无法操作"),
    NOT_ACQUIRE_LOCK(200101, "获取锁失败"),
    CAN_VIEW_ANSWER(200102,"查看答卷"),
    ANSWER_NOT_EMPTY(200103, "答案不能为空"),
    OPTION_NOT_EXIT(200104, "无此选项"),
    REQUIRED_MUST_FILL(200105,"该选项必填框必填"),
    ACTIVITY_END_VIEW_ANSWER(200106, "活动已结束，可以查看提交过的问卷问题及答案"),
    ACTIVITY_END_NOT_VIEW_ANSWER(200207, "活动已结束，无查看问卷链接"),

    NOT_ACQUIRE_PRIZE(300100, "该奖品无法被领取"),
    ALREADY_ACQUIRE_PRIZE(300101, "该奖品已被领取"),
    CREATE_ORDER_FAIL(300102, "创建订单失败"),


    ACTIVITY_USER_RECORD_NOT_NULL(400100, "参与记录不能为空"),
    ACTIVITY_USER_RECORD_DATA_SOURCE_TYPE_NOT_NULL(400101, "参与记录数据来源不能为空"),
    ACTIVITY_USER_RECORD_ACTIVITY_ID_NOT_NULL(400102, "参与记录活动id不能为空"),
    ACTIVITY_USER_RECORD_DATA_SOURCE_ID_NOT_NULL(400103, "参与记录数据来源id"),
    ACTIVITY_USER_RECORD_OPEN_ID_NOT_NULL(400104, "参与记录用户openId不能为空"),
    ACTIVITY_USER_RECORD_ACTIVITY_TITLE_NOT_NULL(400105, "参与记录用户活动名称不能为空"),
    ACTIVITY_USER_RECORD_JOIN_TIME_NOT_NULL(400106, "参与记录用户参与时间不能为空"),
    ACTIVITY_USER_RECORD_ACQUIRE_PRIZE_NOT_NULL(400107, "参与记录用户是否中奖不能为空"),

    CONSUMER_ID_NOT_NULL(500001,"用户id为空,请先登录"),
    CONSUMER_EXIST(500002,"用户不存在"),
    SALE_USER_INFO_EXIST(500003,"手机号已经与您绑定"),
    SALE_USER_INFO_NOT_EXIST(500004,"零售网用户手机号未绑定"),
    SALE_USER_INFO_MOBILE_NOT_EXIST(500005,"手机号未绑定"),
    NEW_OLD_MOBILE_NOT_EQUALS(500006,"新旧手机号不能相同"),
    HANDLER_IS_NULL(500007,"操作不支持"),

    SALE_CERTIFICATE_NOT_EXIST(500008,"专卖证没有被他人使用"),
    SALE_CERTIFICATE_EXIST(500009,"当前专卖号已经被他人使用,是否申诉"),
    SALE_CERTIFICATE_CREATE_BY_NOT_EQUALS(500010,"您已经绑定了这个专卖证"),

    NO_INTERVAL(500011, "未设置风控的发送间隔参数"),
    AUDIT_SHEET_ID_SALE_CERTIFICATE_EXIST(500012,"您已经提交了该专卖证号的审核"),
    SALE_CERTIFICATE_NO_ERROR(500013,"1. 专卖证号格式错误"),
    AUDIT_SHEET_NOT_EXIST(500014,"审核单不存在"),
    AUDIT_SHEET_IS_UPDATE(500015,"审核单请刷新页面后在操作"),
    SALE_USER_INFO_MOBILE_EXIST(500016,"手机号已经被绑定"),

    SEND_VERIFICATION_MAX(500017, "发送间隔达到上限"),
    OTHER_PEOPLE_USED(500018, "号码已被占用"),
    DISTINGUISH_SALE_CERTIFICATE_IMAGE_MAX(500019, "图片识别次数超过两次"),
    SMS_CODE_ERROR(500020, "验证码错误"),
    SALE_USER_INFO_MOBILE_NO_EXIST(500021,"手机号码未被绑定，无需申诉"),
    AUDIT_SHEET_UPDATE_MAX(500022,"今年已无修改机会"),


    BLACK_LIST(600001,"风险账号"),

    OVER_USER_LIMIT(700001,"您已参与{}次，达到活动参与的次数上限，感谢您的支持", "参与次数参数"),
    OVER_REPEAT_LIMIT(700002,"您已于{}领取奖品。本活动{}小时内仅限参与一次, 请于领取奖品{}小时后再次参与。感谢您的支持!", "领取时间参数", "间隔小时", "间隔小时参数"),
    QRCODE_NOT_VALID(700004, "Sorry, 本店二维码未生效，请提示店主完成绑定并签收物资。感谢您的支持!"),
    INSUFFICIENT_STOCK(700005, "Sorry, 本店礼品库存不足，请您前往其他店铺参与活动。感谢您的支持！"),
    SHOP_ACT_END(700006, "Sorry, 本店活动已结束，请您前往其他店铺参与活动。感谢您的支持！"),
    FILTER_BLACK(700007, "Sorry, 您没有本次活动的参与资格，感谢您的支持"),
    CUSTOMER_NOT_REGISTRY(700008, "消费者尚未注册"),
    NOT_ELIGIBLE(700009, "不满足活动资格"),
    MATERIAL_STOCK_INSUFFICIENT(700010, "物料库存不充足"),
    NOT_ACT_QRCODE(700011, "当前二维码不是本活动所选择的二维码"),
    RETAILER_PRIZE_NOT_EXIST(700012,"奖品不存在"),
    RETAILER_STOCK_NOT_ENOUGH(700013,"库存不足"),
    ALREADY_GET(700014,"已领奖"),


    SUCCESS(20000, "成功"),
    ERROR(20001,"内部错误"),

    INVITE_NOT_EXIST(7000001,"邀请码不存在"),

    INVITE_COUNT_LIMIT(2000001,"抱歉，您的好友今日邀请已达上限"),
    ASSIST_COUNT_LIMIT(2000002,"抱歉，您的助力次数已达上限"),
    CAN_NOT_ASSIST_SAME_USER(2000003,"抱歉，您已为该好友助力过啦"),
    CAN_NOT_ASSIST_YOURSELF(2000004,"自己不能为自己助力"),
    STOCK_NOT_ENOUGH(2000005,"奖品库存不足"),
    PRIZE_NOT_EXIST(2000006,"奖品不存在"),

    ALREADY_GET_PRIZE(2000007,"已经领过奖了"),

    ACTIVITY_NOT_EXIST(200001,"活动不存在"),

    VOTE_NUM_NOT_ENOUGH(4000001,"点赞数不足"),
    WORKS_NOT_EXIST(4000002,"作品不存在"),
    CAN_NOT_VOTE_SELF(4000003,"不能给自己的作品投票"),

    VOTE_ONE_USER_LIMIT(4000004,"给同一人投票达到上限"),

    SIGN_UP_LIMIT(4000005,"报名人数超过上限"),

    DISPLAY_STAGE_NOT_EXIT(3000001, "该活动阶段不存在" ),
    DISPLAY_STAGE_UPLOAD_ERROR(3000002, "上传失败"),
    DISPLAY_REGULATE_NOT_EXIT(3000003, "品规配置错误"),
    DISPLAY_POINT_NOT_EXIT(3000004, "积分规则配置错误"),
    DISPLAY_SAVE_ERROR(3000005, "保存图片识别结果识别"),
    DISPLAY_UPLOAD_TIMES_LIMIT(3000006, "上传次数超过上限"),
    DISPLAY_STAGE_CONFIRM_ERROR(3000007, "确认失败"),
    DISPLAY_STAGE_NOT_APPEAL(3000008, "无法申诉"),
    DISPLAY_STAGE_APPEAL_ERROR(3000009, "申诉失败"),
    DISPLAY_STAGE_VOTE_ERROR(3000010,"投票信息获取异常"),
    DISPLAY_STAGE_CONFIG_ERROR(3000011, "活动配置异常"),

    DISPLAY_STAGE_VOTE_FORBID(3000012,"非法操作"),
    DISPLAY_STAGE_VOTE_IS_DEAL(3000013,"该记录已审核")



    ;



    ErrorCodeEnum(int code, String message, String...args) {
        this.code = code;
        this.message = message;
        this.args = args;
    }

    private int code;
    private String message;

    /**
     * 占位符描述信息
     */
    private final String[] args;

    public static String buildArgs(ErrorCodeEnum errorCodeEnum, Object...args) {
        return StrUtil.format(errorCodeEnum.getMessage(), args);
    }

    public static void buildException(boolean expression, ErrorCodeEnum errorCodeEnum, Object...args) throws BizException {
        Conditions.expectTrue(expression, String.valueOf(errorCodeEnum.getCode()), buildArgs(errorCodeEnum, args), null);
    }

    /**
     * 默认抛出异常，填充错误信息和code
     */
    public static void buildException(ErrorCodeEnum errorCodeEnum, Object...args) throws BizException {
        buildException(false, errorCodeEnum, args);
    }

    @Override
    public int errorCode() {
        return code;
    }

    @Override
    public String errorMessage() {
        return message;
    }
}
