package cn.com.duiba.zhongyan.activity.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author xuanyu
 * @description: 作品排序参数
 * @date 2022/8/1 8:33 PM
 */
@AllArgsConstructor
@Getter
public enum WorksOrderTypeEnum {
    WORKS_NO_ASC(0,"参赛编号升序"),
    WORKS_RANK_ASC(1,"作品排名升序");

    private final Integer orderType;

    private final String desc;

    /**
     * 排序方式
     * @param type
     * @return
     */
    public static WorksOrderTypeEnum getOrderTypeEnumByType(Integer type){
        return Arrays.stream(WorksOrderTypeEnum.values()).filter(typeEnum-> Objects.equals(type,typeEnum.getOrderType())).findFirst().orElse(WORKS_NO_ASC);
    }
}
