package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.base.PageResult;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityConsumePrizeCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.ActivityRulePrizeDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.BackPrizeCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.CityLotteryCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.CityPrizeCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.DaySendPrizeCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.PrizeCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.RemoteUserWinPrizeRecordDto;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeOrderDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.UserPrizeRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.WinnerRecordDTO;
import cn.com.duiba.zhongyan.activity.service.api.enums.record.PrizeRecordTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.ActivityDrawCountParam;
import cn.com.duiba.zhongyan.activity.service.api.param.AddWinnerRecordBackIdParam;
import cn.com.duiba.zhongyan.activity.service.api.param.AddWinnerRecordParam;
import cn.com.duiba.zhongyan.activity.service.api.param.BackPrizeStockParam;
import cn.com.duiba.zhongyan.activity.service.api.param.PrizeConditionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.SendPrizeParam;
import cn.com.duiba.zhongyan.activity.service.api.param.UpdateStatusAndBackStockParam;
import cn.com.duiba.zhongyan.activity.service.api.param.UserPrizeRecordConditionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.UserPrizeRecordPageQueryParam;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteChangePointParam;

import java.util.Date;
import java.util.List;

/**
 * @author xuanyu
 * @description: 用户中奖记录表对外服务
 * @date 2021/11/25 5:57 下午
 */
@AdvancedFeignClient
public interface RemoteUserPrizeRecordService {
    /**
     * 根据主键删除
     *
     * @param id 主键id
     * @return 主键id
     */
    Long deleteByPrimaryKey(Long id) throws BizException;

    /**
     * 根据实体插入一条用户中奖记录
     *
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 主键id
     */
    Long insert(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 选择性插入实体中不为null的属性
     *
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 主键id
     */
    Long insertSelective(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据主键id查找记录
     *
     * @param id 主键id
     * @return 一条用户中奖记录
     */
    UserPrizeRecordDTO selectByPrimaryKey(Long id) throws BizException;

    /**
     * 选择性更新实体中不为null的值
     *
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKeySelective(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据主键id更新
     *
     * @param userPrizeRecordDTO 用户中奖记录
     * @return 操作成功的记录条数
     */
    int updateByPrimaryKey(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据查询参数返回中奖记录(含奖品名）,可补充返回奖品表的DTO
     *
     * @param pageQueryParam 查询参数
     * @return
     */
    PageResult<UserPrizeRecordDTO> listUserPrizeRecordEntity(UserPrizeRecordPageQueryParam pageQueryParam) throws BizException;


    /**
     * 分页查询奖品列表
     *
     * @param prizeConditionParam
     * @return
     */
    PageResult<UserPrizeDTO> listWinPrizePageByConditions(PrizeConditionParam prizeConditionParam);

    /**
     * 条件分页查询用户中奖记录
     *
     * @param userPrizeRecordPageQueryParam 用户中奖记录(含用户，奖品关联筛选）
     * @return 用户中奖记录
     */
    PageResult<WinnerRecordDTO> listUserPrizeRecordWithUser(UserPrizeRecordPageQueryParam userPrizeRecordPageQueryParam) throws BizException;

    /**
     * @param userPrizeRecordPageQueryParam
     * @return
     * @throws BizException
     */
    Integer countUserPrizeRecordWithUser(UserPrizeRecordPageQueryParam userPrizeRecordPageQueryParam) throws BizException;

    /**
     * 更新未确认状态的中奖记录未已确认
     *
     * @return 操作成功的条数
     */
    Integer confirmPrizeRecord(Long activityId) throws BizException;

    List<UserPrizeRecordDTO> listUserPrizeByUser(Long activityId, Long userId) throws BizException;


    /**
     * 根据用户id和活动id更新中奖记录
     *
     * @param userPrizeRecordDTO
     * @return
     */
    int updateByUserIdAndActivityIdSelective(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 根据中奖记录id删除未确认状态的中奖记录
     *
     * @param prizeRecordId 中奖记录id
     * @return 操作成功的条数
     */
    Integer deleteByPrimaryKeyAndStatus(Long prizeRecordId) throws BizException;

    /**
     * 根据活动id和userIdList批量查询用户中奖记录
     *
     * @param activityId 活动id
     * @param userIdList 用户列表
     * @return 用户中奖记录
     */
    List<UserPrizeRecordDTO> listUserPrizeByUserIds(Long activityId, List<Long> userIdList) throws BizException;

    /**
     * 添加用户中奖记录
     *
     * @param addWinnerRecordParam 添加中奖记录
     * @return 添加中奖记录
     */
    Boolean addWinnerPrizeRecord(AddWinnerRecordParam addWinnerRecordParam) throws BizException;


    /**
     * 添加用户中奖记录(返回记录Id)
     *
     * @param addWinnerRecordBackIdParam 添加中奖记录
     * @return 添加中奖记录
     */
    Long addWinnerPrizeRecordBackId(AddWinnerRecordBackIdParam addWinnerRecordBackIdParam) throws BizException;

    /**
     * 批量查询用户中奖记录
     *
     * @param userPrizeRecordDTOList 用户中奖记录
     * @return
     */
    Integer insertBatchUserRecord(List<UserPrizeRecordDTO> userPrizeRecordDTOList) throws BizException;

    /**
     * 批量插入用户中奖记录
     *
     * @param userPrizeRecordDTOList 用户中奖记录
     * @return
     */
    Integer insertBatchByCondition(List<UserPrizeRecordDTO> userPrizeRecordDTOList) throws BizException;

    /**
     * 根据条件参数查询记录
     *
     * @param userPrizeRecordConditionParam
     * @return 中奖记录
     */
    List<UserPrizeRecordDTO> listUserPrizeRecordByCondition(UserPrizeRecordConditionParam userPrizeRecordConditionParam) throws BizException;

    /**
     * 根据条件获取双
     *
     * @param userPrizeRecordConditionParam 条件参数
     * @return 数量
     */
    Integer countUserPrizeRecordByCondition(UserPrizeRecordConditionParam userPrizeRecordConditionParam) throws BizException;

    /**
     * 获取奖品回退数量
     *
     * @param backPrizeStockParam
     * @return
     */
    List<BackPrizeCountDTO> groupAndGetBackPrizeCount(BackPrizeStockParam backPrizeStockParam) throws BizException;

    /**
     * 统计分组数量
     *
     * @param backPrizeStockParam
     * @return
     */
    Integer countGroupGetBackPrize(BackPrizeStockParam backPrizeStockParam) throws BizException;

    /**
     * 根据活动id 奖品id 失效时间更新中奖记录状态
     *
     * @param activityId 活动id
     * @param prizeId    奖品id
     * @param expireTime 失效时间
     * @return
     */
    Integer updateStatusByActivityAndPrizeId(Long activityId, Long prizeId, Date expireTime, Byte prizeStatus) throws BizException;

    /**
     * 发奖参数
     *
     * @param sendPrizeParam 发奖参数
     * @return 为true 发奖成功，为false发奖失败
     */
    Boolean sendPrize(SendPrizeParam sendPrizeParam) throws BizException;

    /**
     * 清理未确认的奖品记录
     *
     * @param activityId
     * @return
     */
    Boolean clearUnConfirmPrizeRecord(Long activityId) throws BizException;

    /**
     * 逻辑删除中奖记录
     *
     * @param userPrizeRecordDTO
     * @return
     * @throws BizException
     */
    Boolean deleteRecord(UserPrizeRecordDTO userPrizeRecordDTO) throws BizException;

    /**
     * 更新中奖记录状态
     *
     * @param updateStatusAndBackStockParam
     * @return
     * @throws BizException
     */
    Boolean updateStatusAndBackActivityStock(UpdateStatusAndBackStockParam updateStatusAndBackStockParam) throws BizException;

    /**
     * 回退库存
     *
     * @param backPrizeStockParam
     * @param expireDate
     * @return
     * @deprecated 没有地方调用，废弃
     */
    @Deprecated
    Boolean backPrizeStock(BackPrizeStockParam backPrizeStockParam, Date expireDate) throws BizException;

    /**
     * 根据奖品状态聚合数量
     *
     * @param activityId  活动id
     * @param prizeStatus 奖品状态
     * @return 集合后的奖品
     */
    List<PrizeCountDTO> groupAndCountByStatus(Long activityId, Integer prizeStatus) throws BizException;

    /**
     * 根据活动id、中奖状态、奖品id查询中奖记录
     *
     * @param activityId 活动id
     * @param status     中奖状态
     * @param prizeId    奖品id
     * @return 中奖记录列表
     * @throws BizException 业务异常
     *                      <ul>
     *                          <li>请求参数有误</li>
     *                      </ul>
     */
    List<UserPrizeRecordDTO> listByActivityIdAndStatusAndPrizeId(Long activityId, List<Integer> status, List<Long> prizeId) throws BizException;


    /**
     * 发送过期提醒
     */
    void sendExpirationReminderMessage();

    /**
     * 获取订单关联的活动信息
     *
     * @param orderId 订单ID
     * @return 订单关联的活动信息
     */
    UserPrizeOrderDTO getOrderInfo(String orderId);

    /**
     * 根据奖品Id，扣除本地库存
     *
     * @param prizeId
     * @return
     */
    Boolean deductPrizeStock(Long prizeId);

    /**
     * 活动的中奖uv
     * @param activityId
     * @return
     */
    Long countUserUvByDraw(Long activityId);

    /**
     * 根据订单号和记录类型查询用户中奖记录
     * @param orderCode 订单编号
     * @param recordType 记录类型
     */
    List<UserPrizeRecordDTO> queryByOrderCodeAndRecordType(String orderCode, Integer recordType);



    Integer getActivityWinPrizeCount(ActivityDrawCountParam activityDrawCountParam);


    /**
     * 根据活动id 查个奖品发放的数量
     */

    List<ActivityConsumePrizeCountDTO> getActivityConsumePrizeCount(ActivityDrawCountParam activityDrawCountParam);

    /**
     * 统计活动抽奖兑奖数量
     * @param activityId 活动id
     * @return 数量
     */
    Long countActivityPrizeDrawExchangeCount(Long activityId);

    /**
     * 查询指定时间范围内活动每日发放奖品数量(兑奖发奖)
     * @param activityId 活动id
     * @return
     */
    List<DaySendPrizeCountDTO> queryDateSendPrizeCountList(Long activityId, Date startDate, Date endDate);

    /**
     * 查询各省市区中奖次数
     * @param activityId
     * @return
     */
    List<CityLotteryCountDTO> queryCityLotteryCount(Long activityId);

    /**
     * 查询各省市奖品中奖数量
     * @param activityId 活动id
     * @return
     */
    List<CityPrizeCountDTO> queryCityPrizeCount(Long activityId, PrizeRecordTypeEnum prizeRecordTypeEnum);

    /**
     * 查询某活动下已经中奖的奖品id去重
     * @param activityId 活动id
     * @param prizeRecordTypeEnum 记录类型
     * @return
     */
    List<Long> getDistinctPrizeIdList(Long activityId,PrizeRecordTypeEnum prizeRecordTypeEnum);

    /**
     * 发奖和扣库存
     * @param winnerRecordBackIdParam
     * @param activityRulePrizeDTO
     * @param offset
     * @param remoteChangePointParam  不为空发积分，为空不做处理
     * @return
     * @throws BizException
     */
    RemoteUserWinPrizeRecordDto sendPrizeAndConsumeStock(AddWinnerRecordBackIdParam winnerRecordBackIdParam, ActivityRulePrizeDTO activityRulePrizeDTO, Integer offset, RemoteChangePointParam remoteChangePointParam) throws BizException;
    /**
     * 统计某活动下用户已经获得的奖品数量
     * @param activityId 活动id
     * @param unionId unionId
     * @return 已中奖数量
     */
    Long countUserActivityReceivePrize(Long activityId,String unionId);

    /**
     * b端用 将记录状态从初始状态变更为未确认状态
     * @param activityId 活动id
     */
    void updateRecordStatus(Long activityId);
}
