package cn.com.duiba.zhongyan.activity.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @Description
 * @Date 2022/11/28 17:19
 * @Author LuHui
 */
@Getter
@AllArgsConstructor
public enum KvKeyEnum {
    WEB_FREE_DRAW_TIMES("free_draw_times_%s","免费抽奖次数"),
    WEB_INVITE_DRAW_TIMES("invite_draw_times_%s", "邀请获得抽奖次数"),
    SERVICE_INVITE_DRAW_TIMES("%s_invite_draw_times_%s", "邀请获得抽奖次数"),
    WEB_FIRST_ACCESS_ACTIVITY("first_access_%s", "当日首次访问活动"),
    ;

    private final String key;

    private final String desc;

    /**
     * 免费抽奖次数key
     * @param userId
     * @return
     */
    public static String getWebFreeDrawTimesKey(Long userId){
        return String.format(WEB_FREE_DRAW_TIMES.getKey(), userId);
    }

    /**
     * 邀请获得抽奖次数key
     * @param userId
     * @return
     */
    public static String getWebInviteDrawTimesKey(Long userId){
        return String.format(WEB_INVITE_DRAW_TIMES.getKey(), userId);
    }

    /**
     * 邀请获得抽奖次数key
     * @param activityId
     * @param userId
     * @return
     */
    public static String getServiceInviteDrawTimesKey(Long activityId, Long userId){
        return String.format(SERVICE_INVITE_DRAW_TIMES.getKey(),activityId, userId);
    }

    /**
     * 首次访问活动
     * @param userId
     * @return
     */
    public static String getWebFirstAccessActivity(Long userId){
        return String.format(WEB_FIRST_ACCESS_ACTIVITY.getKey(), userId);
    }
}
