package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author: LuHui
 * @Date: 2022/10/13 16:38
 * @Description: 活动uv记录表
 */
@AdvancedFeignClient
public interface RemoteActivityUvRecordService {

    /**
     * 记录每日uv
     * @param activityId 活动ID
     * @param userId userId
     * @param type 类型
     */
    void accessLogDayUv(Long activityId, Long userId, Integer type) throws BizException;

    /**
     * 统计某天活动uv总数
     * @param activityId
     * @param type
     * @param day
     * @return
     */
    Long countActivityUvDay(Long activityId, Integer type, String day) throws BizException;

    /**
     * 记录每日pv
     * @param activityId
     * @param type
     * @throws BizException
     */
    void accessLogDayPv(Long activityId, Integer type) throws BizException;
}
