package cn.com.duiba.zhongyan.activity.service.api.remoteservice.activity;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.RemoteUserWinPrizeRecordDto;
import cn.com.duiba.zhongyan.activity.service.api.param.record.RemoteChangePointParam;
import cn.com.duiba.zhongyan.activity.service.api.param.sendPrize.SendActivityPrizeParam;

/**
 * @author xuanyu
 * @description:
 * @date 2022/8/18 9:48 AM
 */
@AdvancedFeignClient
public interface RemoteSendPrizeService {
    /**
     *
     * @param sendActivityPrizeParam 发放奖品
     * @return 发放一个奖品
     */
    Long sendOnePrize(SendActivityPrizeParam sendActivityPrizeParam) throws BizException;

    /**
     * 发奖，积分为null则不发积分
     * @param sendActivityPrizeParam 奖品
     * @param remoteChangePointParam 积分
     * @return 中奖记录id和积分明细id，积分为null则积分明细id为null
     * @throws BizException
     */
    RemoteUserWinPrizeRecordDto sendPrize(SendActivityPrizeParam sendActivityPrizeParam, RemoteChangePointParam remoteChangePointParam) throws BizException;
}
