package cn.com.duiba.zhongyan.activity.service.api.remoteservice.punch;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.punch.PunchActivityDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.punch.PunchActivityDetailDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.punch.PunchCountDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.punch.PunchDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.punch.PunchDetailDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.punch.GetPunchDetailParam;
import cn.com.duiba.zhongyan.activity.service.api.param.punch.GetPunchParam;
import cn.com.duiba.zhongyan.activity.service.api.param.punch.InsertPunchRecordParam;
import cn.com.duiba.zhongyan.activity.service.api.param.punch.PunchCountParam;
import cn.com.duiba.zhongyan.activity.service.api.param.punch.PunchDetailConditionParam;
import cn.com.duiba.zhongyan.activity.service.api.param.sendPrize.SendActivityPrizeParam;

import java.util.List;

/**
 * @author xuanyu
 * @description:
 * @date 2022/8/16 11:02 AM
 */
@AdvancedFeignClient
public interface RemotePunchService {
    /**
     * 获取mg打卡活动活动配置
     * @param activityId 活动id
     * @return 活动配置
     */
    PunchActivityDTO getActivityConfig(Long activityId) throws BizException;

    /**
     * 根据条件查询打卡明细
     * @param getPunchDetailParam 查询参数
     * @return 打卡明细
     */
    PunchDetailDTO getPunchDetail(GetPunchDetailParam getPunchDetailParam);

    /**
     * 查询打卡总记录
     * @param getPunchParam 查询参数
     * @return 打卡总记录
     */
    PunchDTO getPunch(GetPunchParam getPunchParam);

    /**
     * 打卡记录
     * @param insertPunchRecordParam 打卡记录参数
     */
    void insertPunchRecord(InsertPunchRecordParam insertPunchRecordParam) throws BizException;

    /**
     * 查询打卡记录,创建时间倒序
     * @param getPunchDetailParam 查询打卡记录参数
     * @return
     */
    List<PunchDetailDTO> getPunchDetailList(GetPunchDetailParam getPunchDetailParam);

    /**
     * 发奖(mg打卡定制)
     * @param sendActivityPrizeParam 发奖参数
     * @return 发奖
     */
    Long punchSendPrize(SendActivityPrizeParam sendActivityPrizeParam) throws BizException;

    /**
     * 查询打卡详情(连表)
     * @param punchDetailConditionParam 打卡详情参数
     * @return
     */
    PageResponse<PunchActivityDetailDTO> listPunchByCondition(PunchDetailConditionParam punchDetailConditionParam);

    /**
     * 分页查询打卡记录,不连表
     * @param activityId
     * @param pageNo
     * @param pageSize
     * @return
     */
    PageResponse<PunchDTO> listPunch(Long activityId,Integer pageNo,Integer pageSize);

    /**
     * 查询活动下用户打卡人数
     * @param activityId 活动id
     * @return
     */
    Long getActivityPunchCount(Long activityId);

    /**
     * 查询活动下用户打卡人数
     * @param activityId
     * @param punchDayCount 查询已经打卡的人数
     * @return
     */
    Long getActivityPunchCountByDayCount(Long activityId,Integer punchDayCount);

    /**
     * 查询每日打卡人数
     * @param punchCountParam
     * @return
     */
    List<PunchCountDTO> countPunchCount(PunchCountParam punchCountParam);



    PunchDetailDTO getNewPunchCountDayDetail(Long activityId,String openId);
}
