package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;

/**
 * @author zht
 * @Date 2022/7/15
 */
public interface ActivitySignStatisticsConfig {

    /**
     * 每日总访问 pv
     */
    String EVERYDAY_ALL_VISIT_PV = "everyday_visit_pv_%s";

    static String getEverydayAllVisitPv(Date day) {
        return String.format(EVERYDAY_ALL_VISIT_PV, DateUtils.getDayNumber(day));
    }

    /**
     * 每日总访问 uv
     */
    String EVERYDAY_ALL_VISIT_UV = "everyday_visit_uv_%s";

    static String getEverydayAllVisitUv(Date day) {
        return String.format(EVERYDAY_ALL_VISIT_UV, DateUtils.getDayNumber(day));
    }


    /**
     * 每日访问 uv 个人限制
     */
    String EVERYDAY_VISIT_USER_LOCK_UV = "everyday_visit_user_lock_uv_%s_%s";

    static String getEverydayVisitUserLockUv(Long userId, Date day) {
        return String.format(EVERYDAY_VISIT_USER_LOCK_UV, userId, DateUtils.getDayNumber(day));
    }


    /**
     * 每日参与 Pv
     */
    String EVERYDAY_JOIN_PV = "everyday_join_pv_%s";

    static String getEverydayJoinPv(Date day) {
        return String.format(EVERYDAY_JOIN_PV, DateUtils.getDayNumber(day));
    }


    /**
     * 每日参与 UV
     */
    String EVERYDAY_JOIN_Uv = "everyday_join_uv_%s";

    static String getEverydayJoinUv(Date day) {
        return String.format(EVERYDAY_JOIN_Uv, DateUtils.getDayNumber(day));
    }

    /**
     * 每日参与 uv 个人限制
     */
    String EVERYDAY_JOIN_USER_LOCK_UV = "everyday_join_user_lock_uv_%s_%s";

    static String getEverydayJoinUserLockUv(Long userId, Date day) {
        return String.format(EVERYDAY_JOIN_USER_LOCK_UV, userId, DateUtils.getDayNumber(day));
    }

    /**
     * 当日点击去完成游戏总数
     */

    String TASK_GAME_COUNT = "task_game_count_%s";

    static String getTaskGameCount(Date day) {
        return String.format(TASK_GAME_COUNT, DateUtils.getDayNumber(day));
    }


    /**
     * 当日点击去完成游戏总数lock
     */

    String TASK_GAME_COUNT_USER_LOCK = "task_game_count_user_lock_%s_%s";

    static String getTaskGameCountUserLock(Long userId, Date day) {
        return String.format(TASK_GAME_COUNT_USER_LOCK, userId, DateUtils.getDayNumber(day));
    }


    /**
     * 当日点击去邀请总数
     */
    String TASK_INVITE_COUNT = "task_invite_count_%s";

    static String getTaskInviteCount(Date day) {
        return String.format(TASK_INVITE_COUNT, DateUtils.getDayNumber(day));
    }

    /**
     * 当日点击去完成游戏总数lock
     */
    String TASK_INVITE_COUNT_USER_LOCK = "task_invite_count_user_lock_%s_%s";

    static String getTaskInviteCountUserLock(Long userId, Date day) {
        return String.format(TASK_INVITE_COUNT_USER_LOCK, userId, DateUtils.getDayNumber(day));
    }

    /**
     * 总去重 访问 uv
     */
    String ALL_VISIT_COUNT = "all_visit_count";

    static String getAllVisitCount() {
        return ALL_VISIT_COUNT;
    }

    /**
     * 总去重访问lock
     */
    String ALL_VISIT_COUNT_USER_LOCK = "all_visit_count_user_lock_%s";

    static String getAllVisitCountUserLock(Long userId) {
        return String.format(ALL_VISIT_COUNT_USER_LOCK, userId);
    }

    /**
     * 总去重 去邀请
     */
    String ALL_INVITE_COUNT = "all_invite_count";

    static String getAllInviteCount() {
        return ALL_INVITE_COUNT;
    }

    /**
     * 总去重 去邀请lock
     */

    String ALL_INVITE_COUNT_USER_LOCK = "all_invite_count_user_lock_%s";

    static String getAllInviteCountUserLock(Long userId) {
        return String.format(ALL_INVITE_COUNT_USER_LOCK, userId);
    }

    /**
     * 总去重 游戏uv
     */
    String ALL_GAME_COUNT = "all_game_count";

    static String getAllGameCount() {
        return ALL_GAME_COUNT;
    }

    /**
     * 总去重 去完成游戏lock
     */
    String ALL_GAME_COUNT_USER_LOCK = "all_game_count_user_lock_%s";

    static String getAllGameCountUserLock(Long userId) {
        return String.format(ALL_GAME_COUNT_USER_LOCK, userId);
    }


}
