package cn.com.duiba.zhongyan.activity.service.api.enums;

import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * @Description 验证码场景值枚举
 * @Author dangcang
 * @Date 2022/3/10 4:47 下午
 **/
@Getter
public enum VerificationSceneEnum {

    REGISTER(1, "注册"),
    CHANGE(2,"更换"),
    APPEAL(3, "申诉"),

    ;

    private Integer scene;

    private String desc;

    VerificationSceneEnum(Integer scene, String desc) {
        this.scene = scene;
        this.desc = desc;
    }

    private static Map<Integer, VerificationSceneEnum> map = new HashMap<Integer, VerificationSceneEnum>() {{
        for (VerificationSceneEnum sceneEnum : VerificationSceneEnum.values()) {
            put(sceneEnum.getScene(), sceneEnum);
        }
    }};

    public static VerificationSceneEnum getByScene(Integer scene) {
        return map.get(scene);
    }
}