package cn.com.duiba.zhongyan.activity.service.api.param;

import cn.com.duiba.zhongyan.activity.service.api.enums.VerificationSceneEnum;
import cn.com.duiba.zhongyan.activity.service.api.enums.VerificationTimeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @Description 发送短信验证码参数
 * @Author dangcang
 * @Date 2022/3/10 1:55 下午
 **/
@Data
public class SendVerificationParam implements Serializable {

    private static final long serialVersionUID = -8733914629796737706L;

    /**
     * 发送验证码的号码
     */
    private String phoneNumber;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 验证码发送场景值
     * @see cn.com.duiba.zhongyan.activity.service.api.enums.VerificationSceneEnum
     */
    private VerificationSceneEnum scene;

    /**
     * 风控间隔校验的key
     * 暂时未开发逻辑 需要用到这个字段可以联系dangcang
     */
    private String key;

    /**
     * 用于判断风控的发送间隔
     * @see cn.com.duiba.zhongyan.activity.service.api.enums.VerificationTimeEnum;
     */
    private VerificationTimeEnum time;

    /**
     * 过期时间 秒为单位
     * 当VerificationTimeEnum = INTERVAL_TIME时需要填写
     */
    private Integer expireTime;

    /**
     * 风控周期最大发送次数
     */
    private Integer maxSendNumber;

    /**
     * 验证码长度
     */
    private Integer codeLength;

    /**
     * 达到上限时报错信息
     * 因为是根据风控周期的描述 因此需要自己传入
     */
    private String errorMessage;
}