package cn.com.duiba.zhongyan.activity.service.api.remoteservice.saleuser;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.AppealDetailDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.AuditSheetDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.CheckDetailDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.DistinguishSaleCertificateImageLogDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.SaleUserAppealListDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.SaleUserCheckListDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteBaseSubmitAuditSheetParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteCheckResultParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteDistinguishSaleCertificateImageParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteGetAppealListParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteGetAuditSheetIdParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteGetCheckListParam;

/**
 * @author linzhou
 * @ClassName AuditSheetService.java
 * @createTime 2022年03月13日 16:03:00
 * @Description
 */
@AdvancedFeignClient
public interface RemoteAuditSheetService {


    /**
     * 专卖证号校验
     *
     * @param saleCertificateNo
     * @throws BizException
     */
    void checkSaleCertificateNo(String saleCertificateNo) throws BizException;

    /**
     * 提交审核
     *
     * @param param
     * @return
     */
    Long submitAuditSheet(RemoteBaseSubmitAuditSheetParam param) throws BizException;

    /**
     * 识别专卖证图片信息
     *
     * @param url
     * @return
     * @throws BizException
     */
    DistinguishSaleCertificateImageLogDTO distinguishSaleCertificateImage(String url) throws BizException;
    DistinguishSaleCertificateImageLogDTO distinguishSaleCertificateImageParam(RemoteDistinguishSaleCertificateImageParam param) throws BizException;


    /**
     * 审核通过
     *
     * @param param
     * @throws BizException
     */
    void passThrough(RemoteCheckResultParam param) throws BizException;

    /**
     * 审核拒绝
     *
     * @throws BizException
     */
    void refuse(RemoteCheckResultParam param) throws BizException;

    /**
     * 查询专卖证申诉单列表
     * @param param
     * @return
     */
    PageResponse<SaleUserAppealListDTO> getAppealList(RemoteGetAppealListParam param);

    /**
     * 查询入网\修改资料审核单列表
     * @param param
     * @return
     */
    PageResponse<SaleUserCheckListDTO> getCheckList(RemoteGetCheckListParam param);

    Long getAppealListCountByParam(RemoteGetAppealListParam param);

    Long getCheckListCountByParam(RemoteGetCheckListParam param);



    /**
     * 获取专卖证申诉单详情
     *
     * @param id 审核单id
     * @return
     */
    AppealDetailDTO getAppealDetail(Long id) throws BizException;

    /**
     * 获取入网\修改资料审核详情
     *
     * @param id 审核单id
     * @return
     */
    CheckDetailDTO getCheckDetail(Long id) throws BizException;

    /**
     * 获取最近一次的指定类型的审核单id
     * @param param
     * @return
     */
    Long getAuditSheetIdByParam(RemoteGetAuditSheetIdParam param);

    AuditSheetDTO getAuditSheetByParam(RemoteGetAuditSheetIdParam param);

}
