package cn.com.duiba.zhongyan.activity.service.api.remoteservice.saleuser;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.wolf.entity.PageResponse;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.RetailerPageDTO;
import cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser.SaleCertificateDTO;
import cn.com.duiba.zhongyan.activity.service.api.param.RemoteSelectRetailerPageParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteChangeCertificateTimeParam;
import cn.com.duiba.zhongyan.activity.service.api.param.saleuser.RemoteSaleCertificateParam;

import java.util.List;

/**
 * Created by hong
 * time 2022/3/22.
 */
@AdvancedFeignClient
public interface RemoteSaleCertificateService {

    SaleCertificateDTO selectOneByCreatedBy(Long createdBy);

    /**
     * 修改专卖证有效期
     *
     * @param param
     * @return
     */
    Boolean changeCertificateTime(RemoteChangeCertificateTimeParam param);

    /**
     * 根据条件查询通过审核的零售户信息
     * @param param 查询参数
     * @return List<SaleCertificateCheckDTO>
     */
    List<SaleCertificateDTO> queryList(RemoteSaleCertificateParam param);

    /**
     * 根据对应用户的审核信息
     * @param createdByList 查询参数
     * @return List<SaleCertificateCheckDTO>
     */
    List<SaleCertificateDTO> queryByCreateByList(List<Long> createdByList);

    /**
     * 根据零售户姓名、店铺名称、手机号分页查询
     * @param param 查询条件
     * @return PageResponse<RetailerPageDTO>
     */
    PageResponse<RetailerPageDTO> pageRetailer(RemoteSelectRetailerPageParam param);
}
