package cn.com.duiba.zhongyan.activity.service.api.param;

import cn.com.duiba.wolf.entity.PageRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author yuanzhixin
 * @version 1.0
 * @date 2022/7/1 11:22
 **/
@Getter
@Setter
@ToString
public class RemoteSelectRetailerPageParam extends PageRequest {

    /**
     * 查询条件
     */
    private String queryKey;

    /**
     * 省
     */
    @NotBlank(message = "省code不能为空")
    private String province;

    /**
     * 市
     */
    @NotBlank(message = "市code不能为空")
    private String city;

    /**
     * 上报状态
     * @see cn.com.duiba.zhongyan.activity.service.api.enums.ReportStateEnum#NOT_REPORT
     * @see cn.com.duiba.zhongyan.activity.service.api.enums.ReportStateEnum#REPORTED
     */
    private Integer state;

    /**
     * 终端业务员id
     * 上报状态不为空时必传
     */
    private Long activityId;

    /**
     * 终端业务员id
     * 上报状态不为空时必传
     */
    private Long terminalId;

    /**
     * 零售户限制,0不限制，1黑名单
     */
    private Integer retailerLimit;

    /**
     * 标签id list
     */
    private List<Long> tagIdList;

    /**
     * 用户群
     */
    private Long customerGroupConfig;
}