package cn.com.duiba.zhongyan.activity.service.api.base;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @author xuanyu
 * @description: 分页结果
 * @date 2021/11/25 5:29 下午
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class PageResult<T> implements Serializable {

    private static final long serialVersionUID = 6428722991339624540L;
    /**
     * 页码
     */
    private Integer pageIndex;

    /**
     * 页容量
     */
    private Integer pageSize;

    /**
     * 总数量
     */
    private Integer total;

    /**
     * 数据
     */
    private List<T> dataList;

    /**
     * 总页数
     */
    private Integer totalPages;

    public PageResult(Integer pageIndex, Integer pageSize, Integer total, List<T> dataList) {
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.total = total;
        this.dataList = dataList;
    }
}
