package cn.com.duiba.zhongyan.activity.service.api.domain.dto.display;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @Description
 * @Date 2022/7/27 14:31
 * @Author LuHui
 */
@Data
public class DisplayIndexDto implements Serializable {
    private static final long serialVersionUID = -4642353760645109469L;

    /**
     * 积分值
     */
    private Long point;
    /**
     * 阶段信息列表
     */
    private List<StageInfoDto> stageInfoVoList;
    /**
     * 活动配置
     */
    private String config;
    /**
     * 活动状态 0:进行中 1:未开始 2:已结束
     */
    private Integer activityStatus;

    @Data
    public static class StageInfoDto implements Serializable{

        private static final long serialVersionUID = -5183334771754412018L;
        /**
         * id
         */
        private Long id;
        /**
         * 开始时间
         */
        private Long startTime;
        /**
         * 结束时间
         */
        private Long endTime;
        /**
         * 说明方式 0:图片 1:文字
         */
        private Integer type;
        /**
         * 文字说明
         */
        private String wordDesc;
        /**
         * 图片说明
         */
        private List<String> imageDesc;
        /**
         * 星光值按钮状态  0:未开始 1:获取星光值 2:已过期 3:查看详情 4:审核中
         */
        private Integer status;
        /**
         * 积分
         */
        private Long point;
        /**
         * 活动状态 0:进行中 1:未开始 2:已结束
         */
        private Integer activityStatus;
        /**
         * 上传次数
         */
        private Integer uploadTimes;

    }
}
