package cn.com.duiba.zhongyan.activity.service.api.domain.dto.saleuser;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/5/12
 */
@Data
public class DistinguishMsgDTO implements Serializable {

    private static final long serialVersionUID = 936444256872300246L;
    /**
     * 审批单id
     */
    private Long checkId;

    /**
     * 照片
     */
    private String saleCertificateImage;

    /**
     * 图片情况
     */
    private String imageInfo;

    /**
     * 许可证置信度
     */
    private String saleCertificateCredit;

    /**
     * 许可证类型
     */
    private String saleCertificateType;

    /**
     * 姓名
     */
    private String name;

    /**
     * 店铺名称
     */
    private String shopName;

    /**
     * 有效期开始
     */
    private Date startTime;

    /**
     * 有效期结束
     */
    private Date endTime;
    /**
     * 上传时间
     */
    private Date uploadTime;


    /**
     * 识别时间
     */
    private Date distinguishTime;
    /**
     * 识别专卖证号
     */
    private String distinguishCertificateNo;

    /**
     * 反馈时间
     */
    private Date feedbackTime;

    /**
     * 反馈原因
     */
    private Integer feedback;

    /**
     * 反馈人
     */
    private String feedbackName;
    /**
     * 反馈人手机号
     */
    private String feedbackPhone;

    /**
     * 专卖证号
     */
    private String certificateNo;

    /**
     * 零售户手机号
     */
    private String certificatePhone;

    /**
     * 店铺地址
     */
    private String address;


    public String toDistinguishInfo(){
        return new StringBuilder().append(this.imageInfo).append("\n")
                .append("许可证类型：").append(this.saleCertificateType).append("\n")
                .append("专卖证号：").append(this.distinguishCertificateNo).append("\n")
                .append("置信度：").append(this.saleCertificateCredit).append("\n")
                .append("店主：").append(this.name).append("\n")
                .append("店名：").append(this.shopName).append("\n")
                .append("地址：").append(this.address).append("\n")
                .append("有效期开始时间：").append(this.startTime).append("\n")
                .append("有效期结束时间：").append(this.endTime).append("\n").toString();
    }
}
