package cn.com.duiba.zhongyan.activity.service.api.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author xuanyu
 * @description: 积分明细记录类型
 * @date 2022/7/15 7:22 PM
 */
@Getter
@AllArgsConstructor
public enum CreditDetailChangeTypeEnum {
    ALL(0,"全部"),
    INCREASE(1,"增加"),
    DECREASE(2,"减少");

    private final Integer type;

    private final String desc;

    public static CreditDetailChangeTypeEnum findEnumByType(Integer type){
        return Arrays.stream(values()).filter(value-> Objects.equals(value.getType(),type)).findFirst().orElse(null);
    }
}
