package cn.com.duiba.zhongyan.activity.service.api.enums;

import cn.com.duiba.zhongyan.activity.service.api.base.BizRuntimeException;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

/**
 * @author xuanyu
 * @description: 投票作品状态
 * @date 2022/8/1 6:18 PM
 */
@Getter
@AllArgsConstructor
public enum WorksStatusEnum {
    WAIT_VERIFY(0,"待审核"),
    PASS(1,"通过"),
    REFUSE(2,"拒绝")
    ;
    private final Integer status;
    private final String desc;


    public  static  WorksStatusEnum getDescByStatus(Integer status){
     return Arrays.stream(WorksStatusEnum.values()).filter(i-> Objects.equals(status,i.getStatus())).findFirst()
             .orElseThrow(()->new BizRuntimeException(ErrorCodeEnum.PARAM_ERROR.errorMessage()));
    }
}
