package cn.com.duiba.zhongyan.activity.service.api.param.exclusive;

import cn.com.duiba.zhongyan.activity.service.api.enums.RegionLimitTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.utils.validate.EnumValid;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 地域配置
 *
 * @author jiangyesheng
 * @version 1.0
 * @date 2022/5/7
 */
@Data
public class ExclusiveQuestionRegionConfig implements Serializable {

    private static final long serialVersionUID = -6156950212047301502L;
    /**
     * 地域限制 0-不限制 1-黑名单 2-白名单
     */
    @EnumValid(target = RegionLimitTypeEnum.class, message = "地域限制值不合法")
    private Integer regionLimit;

    /**
     * 地区列表
     */
    private List<String> region;

}
