/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.zhongyan.activity.service.api.enums;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public enum ActivityStatusEnum {
    ACTIVITY_ALREADY_START(0, "\u8fdb\u884c\u4e2d"),
    ACTIVITY_NOT_START(1, "\u672a\u5f00\u59cb"),
    ACTIVITY_ALREADY_END(2, "\u5df2\u7ed3\u675f");

    private int code;
    private String desc;

    private ActivityStatusEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static int getActivityStatus(String startTime, String endTime) {
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (LocalDateTime.now().isBefore(LocalDateTime.parse(startTime, df))) {
            return ActivityStatusEnum.ACTIVITY_NOT_START.code;
        }
        if (LocalDateTime.now().isAfter(LocalDateTime.parse(endTime, df))) {
            return ActivityStatusEnum.ACTIVITY_ALREADY_END.code;
        }
        return ActivityStatusEnum.ACTIVITY_ALREADY_START.code;
    }

    public static int getActivityStatus(Date startTime, Date endTime) {
        Date now = new Date();
        if (now.before(startTime)) {
            return ActivityStatusEnum.ACTIVITY_NOT_START.code;
        }
        if (now.after(endTime)) {
            return ActivityStatusEnum.ACTIVITY_ALREADY_END.code;
        }
        return ActivityStatusEnum.ACTIVITY_ALREADY_START.code;
    }
}

