package cn.com.duiba.zhongyan.activity.service.api.enums.record;

/**
 * @author wangxukai
 * @description
 * @date ：Created in 2022/3/18
 */

public enum PointRecordChangeTypeEnum {
    DEFAULT(-1,"未知"),
    CODE(1,"扫码"),
    LOTTERY(2,"抽奖"),
    EXCHANGE(3,"兑换奖品"),
    PRIZE(4,"中奖"),
    ADMIN(5,"后台变更"),
    SIGN(6, "每日签到"),
    INVITE(7, "邀请好友"),
    PICTURE_GAME(8,"参与互动游戏"),
    READ(9, "阅读图文"),
    VOTE(10,"投票"),
    JS_ONE(11, "第一阶段"),
    JS_TWO(12, "第二阶段"),
    JS_THREE(13, "第三阶段"),
    JS_FOUR(14, "第四阶段"),
    JS_FIVE(15, "第五阶段"),
    JS_SIX(16, "第六阶段"),
    JS_SEVEN(17, "第七阶段"),
    JS_EIGHT(18, "第八阶段"),
    PK(19,"参与PK"),
    PK_WIN(20,"PK获胜"),
    GENERATE_PICTURE(21,"生成图鉴"),
    CONTINUOUS_SIGN(22,"连续签到"),

    AR(23, "AR"),

    GAME_SUCCESS(24, "游戏成功"),

    ;

    private Integer type;

    private String desc;
    PointRecordChangeTypeEnum(Integer type,String desc){
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getType() {
        return type;
    }

    public static PointRecordChangeTypeEnum getByType(Integer type){
        for(PointRecordChangeTypeEnum changeTypeEnum : PointRecordChangeTypeEnum.values()){
            if(changeTypeEnum.getType().equals(type)){
                return changeTypeEnum;
            }
        }
        return PointRecordChangeTypeEnum.DEFAULT;
    }
}
