package cn.com.duiba.zhongyan.activity.service.api.param;

import java.io.Serializable;
import java.util.List;

/**
 * @author LuHui
 * @description
 * @date 2021/11/26  13:43
 */
public class QuestionAnswerParam implements Serializable {
    private static final long serialVersionUID = -6028126546661676303L;
    /**
     * 题目来源 0-普通题目 1-个人信息题目
     */
    private Integer source;
    /**
     * 个人题目信息id
     */
    private Long infoId;
    /**
     * 个人信息题目版本
     */
    private Integer infoVersion;
    /**
     * 题目id
     */
    private Integer questionId;
    /**
     * 题目类型 （0:单选题 1:多选题 2:填空题 3:下拉题 4:月份题）
     */
    private Integer type;
    /**
     * 标题
     */
    private String title;
    /**
     * 题目必填状态（0 必填 1不必填）
     */
    private Integer questionTipStatus;
    /**
     * 填空题提示语
     */
    private String questionTip;
    /**
     * 0-无跳转规则 1-按选项跳转 2-无条件跳转
     */
    private Integer jumpType;
    /**
     * 无条件跳转的题目id
     */
    private Integer noJumpRuleQuestionId;
    /**
     *选择题
     */
    private List<OptionParam> option;
    /**
     * 答案
     */
    private List<AnswerParam> answerList;
    /**
     * 多选题最少选择个数
     */
    private Integer minSelectNum;
    /**
     * 多选题最多选题个数
     */
    private Integer maxSelectNum;

    public Integer getInfoVersion() {
        return infoVersion;
    }

    public void setInfoVersion(Integer infoVersion) {
        this.infoVersion = infoVersion;
    }

    public Long getInfoId() {
        return infoId;
    }

    public void setInfoId(Long infoId) {
        this.infoId = infoId;
    }

    public Integer getSource() {
        return source;
    }

    public void setSource(Integer source) {
        this.source = source;
    }

    public Integer getJumpType() {
        return jumpType;
    }

    public void setJumpType(Integer jumpType) {
        this.jumpType = jumpType;
    }

    public Integer getNoJumpRuleQuestionId() {
        return noJumpRuleQuestionId;
    }

    public void setNoJumpRuleQuestionId(Integer noJumpRuleQuestionId) {
        this.noJumpRuleQuestionId = noJumpRuleQuestionId;
    }

    public Integer getQuestionId() {
        return questionId;
    }

    public void setQuestionId(Integer questionId) {
        this.questionId = questionId;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getQuestionTipStatus() {
        return questionTipStatus;
    }

    public void setQuestionTipStatus(Integer questionTipStatus) {
        this.questionTipStatus = questionTipStatus;
    }

    public String getQuestionTip() {
        return questionTip;
    }

    public void setQuestionTip(String questionTip) {
        this.questionTip = questionTip;
    }


    public List<OptionParam> getOption() {
        return option;
    }

    public void setOption(List<OptionParam> option) {
        this.option = option;
    }

    public List<AnswerParam> getAnswerList() {
        return answerList;
    }

    public void setAnswerList(List<AnswerParam> answerList) {
        this.answerList = answerList;
    }

    public Integer getMinSelectNum() {
        return minSelectNum;
    }

    public void setMinSelectNum(Integer minSelectNum) {
        this.minSelectNum = minSelectNum;
    }

    public Integer getMaxSelectNum() {
        return maxSelectNum;
    }

    public void setMaxSelectNum(Integer maxSelectNum) {
        this.maxSelectNum = maxSelectNum;
    }
}
