package cn.com.duiba.zhongyan.activity.service.api.remoteservice.statistics;

import cn.com.duiba.wolf.utils.DateUtils;

import java.util.Date;

/**
 * @author zht
 * @Date 2022/8/4
 */
public interface ActivityVoteStaticConfig {
    /**
     * 全部pv
     */
    String ALL_VISIT_VOTE_PV = "all_visit_vote_pv";

    static String getAllVisitVotePv() {
        return ALL_VISIT_VOTE_PV;
    }

//----------------------------------------------------------
    /**
     * 全部访问uv
     */
    String ALL_VISIT_VOTE_UV = "all_visit_vote_uv";

    static String getAllVisitVoteUv() {
        return ALL_VISIT_VOTE_UV;
    }

    /**
     * 全部访问uv 用户锁
     */
    String ALL_VISIT_VOTE_UV_LOCK = "all_visit_vote_uv_lock_%s";

    static String getAllVisitVoteUvLock(Long userId) {
        return String.format(ALL_VISIT_VOTE_UV_LOCK, userId);
    }

//----------------------------------------------------------
    /**
     * 全部参与投票UV
     */
    String ALL_JOIN_VOTE_UV = "all_join_vote_uv";

    static String getAllJoinVoteUv() {
        return ALL_JOIN_VOTE_UV;
    }

    /**
     * * 全部参与投票UV 用户锁
     */
    String ALL_JOIN_VOTE_UV_LOCK = "all_join_vote_uv_lock_%s";

    static String getAllJoinVoteUvLock(Long userId) {
        return String.format(ALL_JOIN_VOTE_UV_LOCK, userId);
    }

//----------------------------------------------------------

    /**
     * 全部参与报名的uv
     */
    String ALl_JOIN_ENROLL_UV = "all_join_enroll_uv";

    static String getallJoinEnrollUv() {
        return ALl_JOIN_ENROLL_UV;
    }

    /**
     * *  全部参与报名的uv 用户锁
     */
    String ALl_JOIN_ENROLL_UV_LOCK = "all_join_enroll_uv_lock_%s";

    static String getAllEnrollUvLock(Long userId) {
        return String.format(ALl_JOIN_ENROLL_UV_LOCK, userId);
    }

    /**
     * 根据type 记录每日数据
     */
    String EVERYDAY_DATA_BY_TYPE = "everyday_data_by_type_%s_%s";

    static String getEverydayDataByType(Integer type, Date day) {
        return String.format(EVERYDAY_DATA_BY_TYPE, type, DateUtils.getDayNumber(day));
    }

    /**
     * 每日用户锁
     */
    String EVERYDAY_DATA_BY_TYPE_USER_LOCK = "everyday_data_user_lock_%s_%s_%s";

    static String getEverydayDataByTypeUserLock(Integer type, Long userId, Date day) {
        return String.format(EVERYDAY_DATA_BY_TYPE_USER_LOCK, type, userId, DateUtils.getDayNumber(day));
    }


}
