package cn.com.duiba.zhongyan.activity.service.api.utils.question;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.cloud.biz.tool.utils.Conditions;
import cn.com.duiba.zhongyan.activity.service.api.enums.QuestionTypeEnum;
import cn.com.duiba.zhongyan.activity.service.api.param.AnswerParam;
import cn.com.duiba.zhongyan.activity.service.api.param.QuestionAnswerParam;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author: LuHui
 * @date: 2023/8/15 11:41
 * @description: 顺序题
 */
public class OrderChoiceHandle  extends AbstractQuestionAnswerCheckHandler{



    @Override
    public QuestionTypeEnum getType() {
        return QuestionTypeEnum.ORDER_CHOICE;
    }

    @Override
    void specificQuestionCheck(QuestionAnswerParam param) throws BizException {
        Conditions.expectTrue(StringUtils.isNotBlank(param.getTitle()) && param.getTitle().length() <= 50, "题目["+ param.getQuestionId() +"]:标题不能超过50个字符");
        commonChoiceQuestionCheck(param, 200);
    }

    @Override
    String specificAnswerCheck(QuestionAnswerParam param, AnswerCheckContext context) throws BizException {
        List<String> answerIdList = param.getAnswerList().stream().map(AnswerParam::getAnswer).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        Conditions.expectTrue(answerIdList.size() == param.getOption().size(), String.format("第%s题必选%s个选项！", context.getQuestionNo(), param.getOption().size()));
        return EMPTY_STRING;
    }
}
