package cn.com.duiba.zhongyan.activity.service.api.enums;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.zhongyan.activity.service.api.enums.record.PointRecordChangeTypeEnum;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Description
 * @Date 2022/8/5 18:07
 * @Author LuHui
 */
public enum DisplayStagePointTypeEnum {
    ONE(1,11, "第一阶段"),
    TWO(2,12, "第二阶段"),
    THREE(3,13, "第三阶段"),
    FOUR(4,14, "第四阶段"),
    FIVE(5,15, "第五阶段"),
    SIX(6,16, "第六阶段"),
    SEVEN(7,17, "第七阶段"),
    EIGHT(8,18, "第八阶段"),

    ;
    /**
     * 阶段
     */
    private Integer stage;
    /**
     * @see cn.com.duiba.zhongyan.activity.service.api.enums.record.PointRecordChangeTypeEnum
     * 积分变更类型
     */
    private Integer changeType;
    /**
     * 阶段名
     */
    private String desc;

    DisplayStagePointTypeEnum(Integer stage, Integer changeType, String desc) {
        this.stage = stage;
        this.changeType = changeType;
        this.desc = desc;
    }

    public Integer getStage() {
        return stage;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public String getDesc() {
        return desc;
    }

    public static DisplayStagePointTypeEnum getEnum(Integer stage) throws BizException {
        return Arrays.stream(DisplayStagePointTypeEnum.values()).filter(x -> Objects.equals(x.getStage(), stage)).findFirst().orElseThrow(() -> new BizException("活动阶段不存在"));
    }

    public static PointRecordChangeTypeEnum getChangeTypeEnumByStage(Integer stageId) throws BizException {
        DisplayStagePointTypeEnum displayStagePointTypeEnum = getEnum(stageId);
        return PointRecordChangeTypeEnum.getByType(displayStagePointTypeEnum.changeType);
    }
}
